/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.guides.wknd.core.models.impl;

import com.adobe.aem.guides.wknd.core.models.Byline;
import com.adobe.cq.wcm.core.components.models.Image;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.apache.sling.models.factory.ModelFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Byline.class}, resourceType={"wknd/components/byline"}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
public class BylineImpl
implements Byline {
    protected static final String RESOURCE_TYPE = "wknd/components/byline";
    @Self
    private SlingHttpServletRequest request;
    @OSGiService
    private ModelFactory modelFactory;
    @ValueMapValue
    private String name;
    @ValueMapValue
    private List<String> occupations;
    private Image image;

    @PostConstruct
    private void init() {
        this.image = (Image)this.modelFactory.getModelFromWrappedRequest(this.request, this.request.getResource(), Image.class);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getOccupations() {
        if (this.occupations != null) {
            Collections.sort(this.occupations);
            return new ArrayList<String>(this.occupations);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isEmpty() {
        Image image = this.getImage();
        if (StringUtils.isBlank((CharSequence)this.name)) {
            return true;
        }
        if (this.occupations == null || this.occupations.isEmpty()) {
            return true;
        }
        return image == null || StringUtils.isBlank((CharSequence)image.getSrc());
    }

    private Image getImage() {
        return this.image;
    }
}

