/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.guides.wknd.core.models.impl;

import com.adobe.aem.guides.wknd.core.models.ImageList;
import com.adobe.cq.wcm.core.components.models.List;
import com.adobe.cq.wcm.core.components.models.ListItem;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.QueryBuilder;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import javax.jcr.Session;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Required;
import org.apache.sling.models.annotations.Via;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.via.ResourceSuperType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={ImageList.class}, resourceType={"wknd/components/image-list"}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
public class ImageListImpl
implements ImageList {
    private static final Logger log = LoggerFactory.getLogger(ImageListImpl.class);
    protected static final String RESOURCE_TYPE = "wknd/components/image-list";
    @Self
    @Required
    private SlingHttpServletRequest request;
    @OSGiService
    @Required
    private QueryBuilder queryBuilder;
    @Self
    @Via(type=ResourceSuperType.class)
    private List coreList;
    private java.util.List<ImageList.ListItem> imageListItems;

    @Override
    public final Collection<ImageList.ListItem> getListItems() {
        if (this.imageListItems == null) {
            if (this.coreList == null) {
                log.warn("Could not locate the AEM WCM Core Components List SlingModel via this component's ResourceSuperType. Returning an empty list.");
                this.imageListItems = Collections.EMPTY_LIST;
            } else {
                this.imageListItems = this.coreList.getListItems().stream().map(listItem -> new ImageListItemImpl(this.request.getResourceResolver(), (ListItem)listItem)).filter(imageListItem -> !imageListItem.isEmpty()).collect(Collectors.toList());
            }
        }
        return ImmutableList.copyOf(this.imageListItems);
    }

    @Override
    public final boolean isEmpty() {
        return this.getListItems().isEmpty();
    }

    protected java.util.List<Resource> findPageComponentResources(Page page, String slingResourceType, int limit) {
        ArrayList<Resource> componentResources = new ArrayList<Resource>();
        if (page == null) {
            return componentResources;
        }
        ImmutableMap params = ImmutableMap.builder().put((Object)"path", (Object)page.getContentResource().getPath()).put((Object)"type", (Object)"nt:unstructured").put((Object)"property", (Object)"sling:resourceType").put((Object)"property.value", (Object)slingResourceType).put((Object)"p.limit", (Object)String.valueOf(limit)).put((Object)"p.guessTotal", (Object)"true").put((Object)"orderby", (Object)"@jcr:path").put((Object)"orderby.sort", (Object)"asc").build();
        long start = System.currentTimeMillis();
        Iterator resources = this.queryBuilder.createQuery(PredicateGroup.create((Map)params), (Session)this.request.getResourceResolver().adaptTo(Session.class)).getResult().getResources();
        ResourceResolver leakingResourceResolver = null;
        while (resources.hasNext()) {
            Resource resource = (Resource)resources.next();
            if (leakingResourceResolver == null) {
                leakingResourceResolver = resource.getResourceResolver();
            }
            componentResources.add(this.request.getResourceResolver().getResource(resource.getPath()));
        }
        if (leakingResourceResolver != null) {
            leakingResourceResolver.close();
        }
        log.debug("Query searching for component of type [ {} ] over [ {} ] took [ {} ms ]", new Object[]{slingResourceType, page.getContentResource().getPath(), System.currentTimeMillis() - start});
        return componentResources;
    }

    protected static class SimpleImageComponentResource
    extends ResourceWrapper {
        private static final String PN_FILE_REFERENCE = "fileReference";
        private static final String PN_ALT = "alt";
        private ValueMap properties = new ValueMapDecorator(new HashMap());

        public SimpleImageComponentResource(Resource resource, String alt) {
            super(resource);
            this.properties.put((Object)PN_FILE_REFERENCE, resource.getValueMap().get((Object)PN_FILE_REFERENCE));
            this.properties.put((Object)PN_ALT, (Object)alt);
            this.properties.put((Object)"isDecorative", (Object)false);
            this.properties.put((Object)"displayPopupTitle", (Object)false);
            this.properties.put((Object)"titleValueFromDAM", (Object)false);
        }

        public ValueMap getValueMap() {
            return this.properties;
        }

        public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
            if (type != ValueMap.class) {
                return (AdapterType)super.adaptTo(type);
            }
            return (AdapterType)this.getValueMap();
        }
    }

    private class ImageListItemImpl
    implements ImageList.ListItem {
        private static final String IMAGE_RESOURCE_TYPE = "wknd/components/image";
        private final ListItem wrappedListItem;
        private final Resource image;
        private final Page page;

        public ImageListItemImpl(ResourceResolver resourceResolver, ListItem listItem) {
            PageManager pageManager = (PageManager)resourceResolver.adaptTo(PageManager.class);
            this.wrappedListItem = listItem;
            this.page = pageManager.getContainingPage(this.wrappedListItem.getPath());
            this.image = ImageListImpl.this.findPageComponentResources(this.page, IMAGE_RESOURCE_TYPE, 1).stream().map(r -> new SimpleImageComponentResource((Resource)r, this.getTitle())).findFirst().orElse(null);
        }

        @Override
        public final Resource getImage() {
            return this.image;
        }

        @Override
        public String getTitle() {
            return this.wrappedListItem.getTitle();
        }

        @Override
        public String getDescription() {
            return (String)this.page.getProperties().get("shortDescription", (Object)this.page.getDescription());
        }

        @Override
        public String getURL() {
            return this.wrappedListItem.getURL();
        }

        public boolean isEmpty() {
            return this.getImage() == null;
        }
    }
}

