/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.resources.ResourceFolderType;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkVersionInfo;
import com.android.tools.lint.checks.ApiLookup;
import com.android.tools.lint.checks.RtlDetector;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.Pair;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.ast.Annotation;
import lombok.ast.AnnotationElement;
import lombok.ast.AnnotationValue;
import lombok.ast.AstVisitor;
import lombok.ast.BinaryExpression;
import lombok.ast.Case;
import lombok.ast.Catch;
import lombok.ast.ClassDeclaration;
import lombok.ast.ConstructorDeclaration;
import lombok.ast.ConstructorInvocation;
import lombok.ast.Expression;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.Identifier;
import lombok.ast.If;
import lombok.ast.ImportDeclaration;
import lombok.ast.InlineIfExpression;
import lombok.ast.IntegralLiteral;
import lombok.ast.MethodDeclaration;
import lombok.ast.MethodInvocation;
import lombok.ast.Modifiers;
import lombok.ast.Node;
import lombok.ast.Select;
import lombok.ast.StrictListAccessor;
import lombok.ast.StringLiteral;
import lombok.ast.SuperConstructorInvocation;
import lombok.ast.Switch;
import lombok.ast.Try;
import lombok.ast.TypeReference;
import lombok.ast.VariableDefinition;
import lombok.ast.VariableDefinitionEntry;
import lombok.ast.VariableReference;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ApiDetector
extends ResourceXmlDetector
implements Detector.ClassScanner,
Detector.JavaScanner {
    private static final boolean CHECK_DECLARATIONS = false;
    private static final boolean AOSP_BUILD = System.getenv("ANDROID_BUILD_TOP") != null;
    public static final Issue UNSUPPORTED = Issue.create((String)"NewApi", (String)"Calling new methods on older versions", (String)"This check scans through all the Android API calls in the application and warns about any calls that are not available on *all* versions targeted by this application (according to its minimum SDK attribute in the manifest).\n\nIf you really want to use this API and don't need to support older devices just set the `minSdkVersion` in your `build.gradle` or `AndroidManifest.xml` files.\nIf your code is *deliberately* accessing newer APIs, and you have ensured (e.g. with conditional execution) that this code will only ever be called on a supported platform, then you can annotate your class or method with the `@TargetApi` annotation specifying the local minimum SDK to apply, such as `@TargetApi(11)`, such that this check considers 11 rather than your manifest file's minimum SDK as the required API level.\n\nIf you are deliberately setting `android:` attributes in style definitions, make sure you place this in a `values-vNN` folder in order to avoid running into runtime conflicts on certain devices where manufacturers have added custom attributes whose ids conflict with the new ones on later platforms.\n\nSimilarly, you can use tools:targetApi=\"11\" in an XML file to indicate that the element will only be inflated in an adequate context.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.ERROR, (Implementation)new Implementation(ApiDetector.class, EnumSet.of(Scope.CLASS_FILE, Scope.RESOURCE_FILE, Scope.MANIFEST), new EnumSet[]{Scope.RESOURCE_FILE_SCOPE, Scope.CLASS_FILE_SCOPE, Scope.MANIFEST_SCOPE}));
    public static final Issue INLINED = Issue.create((String)"InlinedApi", (String)"Using inlined constants on older versions", (String)"This check scans through all the Android API field references in the application and flags certain constants, such as static final integers and Strings, which were introduced in later versions. These will actually be copied into the class files rather than being referenced, which means that the value is available even when running on older devices. In some cases that's fine, and in other cases it can result in a runtime crash or incorrect behavior. It depends on the context, so consider the code carefully and device whether it's safe and can be suppressed or whether the code needs tbe guarded.\n\nIf you really want to use this API and don't need to support older devices just set the `minSdkVersion` in your `build.gradle` or `AndroidManifest.xml` files.\nIf your code is *deliberately* accessing newer APIs, and you have ensured (e.g. with conditional execution) that this code will only ever be called on a supported platform, then you can annotate your class or method with the `@TargetApi` annotation specifying the local minimum SDK to apply, such as `@TargetApi(11)`, such that this check considers 11 rather than your manifest file's minimum SDK as the required API level.\n", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.WARNING, (Implementation)new Implementation(ApiDetector.class, Scope.JAVA_FILE_SCOPE));
    public static final Issue OVERRIDE = Issue.create((String)"Override", (String)"Method conflicts with new inherited method", (String)"Suppose you are building against Android API 8, and you've subclassed Activity. In your subclass you add a new method called `isDestroyed`(). At some later point, a method of the same name and signature is added to Android. Your method will now override the Android method, and possibly break its contract. Your method is not calling `super.isDestroyed()`, since your compilation target doesn't know about the method.\n\nThe above scenario is what this lint detector looks for. The above example is real, since `isDestroyed()` was added in API 17, but it will be true for *any* method you have added to a subclass of an Android class where your build target is lower than the version the method was introduced in.\n\nTo fix this, either rename your method, or if you are really trying to augment the builtin method if available, switch to a higher build target where you can deliberately add `@Override` on your overriding method, and call `super` if appropriate etc.\n", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.ERROR, (Implementation)new Implementation(ApiDetector.class, Scope.CLASS_FILE_SCOPE));
    public static final Issue UNUSED = Issue.create((String)"UnusedAttribute", (String)"Attribute unused on older versions", (String)"This check finds attributes set in XML files that were introduced in a version newer than the oldest version targeted by your application (with the the `minSdkVersion` attribute).\n\nThis is not an error; the application will simply ignore the attribute. However, if the attribute is important to the appearance of functionality of your application, you should consider finding an alternative way to achieve the same result with only available attributes, and then you can optionally create a copy of the layout in a layout-vNN folder which will be used on API NN or higher where you can take advantage of the newer attribute.\n\nNote: This check does not only apply to attributes. For example, some tags can be unused too, such as the new `<tag>` element in layouts introduced in API 21.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.WARNING, (Implementation)new Implementation(ApiDetector.class, Scope.RESOURCE_FILE_SCOPE));
    private static final String TARGET_API_VMSIG = "/TargetApi;";
    private static final String SWITCH_TABLE_PREFIX = "$SWITCH_TABLE$";
    private static final String ORDINAL_METHOD = "ordinal";
    public static final String ENUM_SWITCH_PREFIX = "$SwitchMap$";
    private static final String TAG_RIPPLE = "ripple";
    private static final String TAG_VECTOR = "vector";
    private static final String TAG_ANIMATED_VECTOR = "animated-vector";
    private static final String TAG_ANIMATED_SELECTOR = "animated-selector";
    protected ApiLookup mApiDatabase;
    private boolean mWarnedMissingDb;
    private int mMinApi = -1;
    private Map<String, List<Pair<String, Location>>> mPendingFields;

    @NonNull
    public Speed getSpeed() {
        return Speed.SLOW;
    }

    public void beforeCheckProject(@NonNull Context context) {
        this.mApiDatabase = ApiLookup.get(context.getClient());
        if (this.mApiDatabase == null && !this.mWarnedMissingDb) {
            this.mWarnedMissingDb = true;
            context.report(IssueRegistry.LINT_ERROR, Location.create((File)context.file), "Can't find API database; API check not performed");
        }
    }

    public boolean appliesTo(@NonNull ResourceFolderType folderType) {
        return true;
    }

    public Collection<String> getApplicableElements() {
        return ALL;
    }

    public Collection<String> getApplicableAttributes() {
        return ALL;
    }

    public void visitAttribute(@NonNull XmlContext context, @NonNull Attr attribute) {
        int minSdk;
        int api;
        String prefix;
        String owner;
        if (this.mApiDatabase == null) {
            return;
        }
        int attributeApiLevel = -1;
        if ("http://schemas.android.com/apk/res/android".equals(attribute.getNamespaceURI())) {
            int minSdk2;
            String name = attribute.getLocalName();
            if (!(name.equals("layout_width") && !name.equals("layout_height") && !name.equals("id") || (attributeApiLevel = this.mApiDatabase.getFieldVersion(owner = "android/R$attr", name)) <= (minSdk2 = this.getMinSdk((Context)context)) || attributeApiLevel <= context.getFolderVersion() || attributeApiLevel <= ApiDetector.getLocalMinSdk(attribute.getOwnerElement()) || ApiDetector.isBenignUnusedAttribute(name) || ApiDetector.isAlreadyWarnedDrawableFile(context, attribute, attributeApiLevel))) {
                String message;
                Location location;
                if (RtlDetector.isRtlAttributeName(name)) {
                    if (name.equals("paddingStart") && ApiDetector.viewMayExtendTextView(attribute.getOwnerElement())) {
                        location = context.getLocation((org.w3c.dom.Node)attribute);
                        message = String.format("Attribute `%1$s` referenced here can result in a crash on some specific devices older than API %2$d (current min is %3$d)", attribute.getLocalName(), attributeApiLevel, minSdk2);
                        context.report(UNSUPPORTED, (org.w3c.dom.Node)attribute, location, message);
                    }
                } else {
                    location = context.getLocation((org.w3c.dom.Node)attribute);
                    message = String.format("Attribute `%1$s` is only used in API level %2$d and higher (current min is %3$d)", attribute.getLocalName(), attributeApiLevel, minSdk2);
                    context.report(UNUSED, (org.w3c.dom.Node)attribute, location, message);
                }
            }
            if (name.equals("divider")) {
                return;
            }
        }
        String value = attribute.getValue();
        owner = null;
        String name = null;
        if (value.startsWith("@android:")) {
            prefix = "@android:";
        } else if (value.startsWith("?android:")) {
            prefix = "?android:";
        } else if (value.startsWith("android:") && "name".equals(attribute.getName()) && "item".equals(attribute.getOwnerElement().getTagName()) && attribute.getOwnerElement().getParentNode() != null && "style".equals(attribute.getOwnerElement().getParentNode().getNodeName())) {
            owner = "android/R$attr";
            name = value.substring("android:".length());
            prefix = null;
        } else if (value.startsWith("android:") && "parent".equals(attribute.getName()) && "style".equals(attribute.getOwnerElement().getTagName())) {
            owner = "android/R$style";
            name = ApiDetector.getFieldName(value.substring("android:".length()));
            prefix = null;
        } else {
            return;
        }
        if (owner == null) {
            int index = value.indexOf(47, prefix.length());
            if (index != -1) {
                owner = "android/R$" + value.substring(prefix.length(), index);
                name = ApiDetector.getFieldName(value.substring(index + 1));
            } else if (value.startsWith("?android:")) {
                owner = "android/R$attr";
                name = value.substring("?android:".length());
            } else {
                return;
            }
        }
        if ((api = this.mApiDatabase.getFieldVersion(owner, name)) > (minSdk = this.getMinSdk((Context)context)) && api > context.getFolderVersion() && api > ApiDetector.getLocalMinSdk(attribute.getOwnerElement())) {
            if ("http://schemas.android.com/tools".equals(attribute.getNamespaceURI())) {
                return;
            }
            if (attributeApiLevel < api) {
                if (attributeApiLevel > minSdk) {
                    String attributeName = attribute.getLocalName();
                    Location location = context.getLocation((org.w3c.dom.Node)attribute);
                    String message = String.format("`%1$s` requires API level %2$d (current min is %3$d), but note that attribute `%4$s` is only used in API level %5$d and higher", name, api, minSdk, attributeName, attributeApiLevel);
                    context.report(UNSUPPORTED, (org.w3c.dom.Node)attribute, location, message);
                } else {
                    Location location = context.getLocation((org.w3c.dom.Node)attribute);
                    String message = String.format("`%1$s` requires API level %2$d (current min is %3$d)", value, api, minSdk);
                    context.report(UNSUPPORTED, (org.w3c.dom.Node)attribute, location, message);
                }
            }
        }
    }

    private static boolean viewMayExtendTextView(@NonNull Element element) {
        String tag = element.getTagName();
        if (tag.equals("view") && ((tag = element.getAttribute("class")) == null || tag.isEmpty())) {
            return false;
        }
        if (tag.indexOf(46) != -1) {
            return true;
        }
        return tag.contains("Text") || tag.contains("Button") || tag.equals("DigitalClock") || tag.equals("Chronometer") || tag.equals("CheckBox") || tag.equals("Switch");
    }

    private static boolean isAlreadyWarnedDrawableFile(@NonNull XmlContext context, @NonNull Attr attribute, int attributeApiLevel) {
        String root;
        return context.getResourceFolderType() == ResourceFolderType.DRAWABLE && attributeApiLevel == 21 && (TAG_RIPPLE.equals(root = attribute.getOwnerDocument().getDocumentElement().getTagName()) || TAG_VECTOR.equals(root) || TAG_ANIMATED_VECTOR.equals(root) || TAG_ANIMATED_SELECTOR.equals(root));
    }

    public static boolean isBenignUnusedAttribute(@NonNull String name) {
        return "labelFor".equals(name) || "textIsSelectable".equals(name);
    }

    private static String getFieldName(String styleName) {
        return styleName.replace('.', '_').replace('-', '_').replace(':', '_');
    }

    public void visitElement(@NonNull XmlContext context, @NonNull Element element) {
        if (this.mApiDatabase == null) {
            return;
        }
        String tag = element.getTagName();
        ResourceFolderType folderType = context.getResourceFolderType();
        if (folderType != ResourceFolderType.LAYOUT) {
            if (folderType == ResourceFolderType.DRAWABLE) {
                this.checkElement(context, element, TAG_RIPPLE, 21, UNSUPPORTED);
                this.checkElement(context, element, TAG_VECTOR, 21, UNSUPPORTED);
                this.checkElement(context, element, TAG_ANIMATED_SELECTOR, 21, UNSUPPORTED);
                this.checkElement(context, element, TAG_ANIMATED_VECTOR, 21, UNSUPPORTED);
            }
            if (element.getParentNode().getNodeType() != 1) {
                return;
            }
            NodeList childNodes = element.getChildNodes();
            int n = childNodes.getLength();
            for (int i = 0; i < n; ++i) {
                int minSdk;
                int api;
                int index;
                String text;
                org.w3c.dom.Node textNode = childNodes.item(i);
                if (textNode.getNodeType() != 3 || !(text = textNode.getNodeValue()).contains("@android:") || (index = (text = text.trim()).indexOf(47, "@android:".length())) == -1) continue;
                String owner = "android/R$" + text.substring("@android:".length(), index);
                String name = text.substring(index + 1);
                if (name.indexOf(46) != -1) {
                    name = name.replace('.', '_');
                }
                if ((api = this.mApiDatabase.getFieldVersion(owner, name)) <= (minSdk = this.getMinSdk((Context)context)) || api <= context.getFolderVersion() || api <= ApiDetector.getLocalMinSdk(element)) continue;
                Location location = context.getLocation(textNode);
                String message = String.format("`%1$s` requires API level %2$d (current min is %3$d)", text, api, minSdk);
                context.report(UNSUPPORTED, (org.w3c.dom.Node)element, location, message);
            }
        } else {
            int minSdk;
            int api;
            if ("view".equals(tag)) {
                tag = element.getAttribute("class");
                if (tag == null || tag.isEmpty()) {
                    return;
                }
            } else {
                this.checkElement(context, element, "tag", 21, UNUSED);
            }
            if (tag.indexOf(46) != -1) {
                return;
            }
            String fqn = "android/widget/" + tag;
            if (tag.equals("TextureView")) {
                fqn = "android/view/TextureView";
            }
            if ((api = this.mApiDatabase.getClassVersion(fqn)) > (minSdk = this.getMinSdk((Context)context)) && api > context.getFolderVersion() && api > ApiDetector.getLocalMinSdk(element)) {
                Location location = context.getLocation((org.w3c.dom.Node)element);
                String message = String.format("View requires API level %1$d (current min is %2$d): `<%3$s>`", api, minSdk, tag);
                context.report(UNSUPPORTED, (org.w3c.dom.Node)element, location, message);
            }
        }
    }

    private void checkElement(@NonNull XmlContext context, @NonNull Element element, @NonNull String tag, int api, @NonNull Issue issue) {
        int minSdk;
        if (tag.equals(element.getTagName()) && api > (minSdk = this.getMinSdk((Context)context)) && api > context.getFolderVersion() && api > ApiDetector.getLocalMinSdk(element)) {
            String message;
            Location location = context.getLocation((org.w3c.dom.Node)element);
            if (issue == UNSUPPORTED) {
                message = String.format("`<%1$s>` requires API level %2$d (current min is %3$d)", tag, api, minSdk);
            } else {
                assert (issue == UNUSED) : issue;
                message = String.format("`<%1$s>` is only used in API level %2$d and higher (current min is %3$d)", tag, api, minSdk);
            }
            context.report(issue, (org.w3c.dom.Node)element, location, message);
        }
    }

    protected int getMinSdk(Context context) {
        if (this.mMinApi == -1) {
            AndroidVersion minSdkVersion = context.getMainProject().getMinSdkVersion();
            this.mMinApi = minSdkVersion.getFeatureLevel();
        }
        return this.mMinApi;
    }

    public void checkClass(@NonNull ClassContext context, @NonNull ClassNode classNode) {
        List methodList;
        if (this.mApiDatabase == null) {
            return;
        }
        if (AOSP_BUILD && classNode.name.startsWith("android/support/")) {
            return;
        }
        int classMinSdk = ApiDetector.getClassMinSdk(context, classNode);
        if (classMinSdk == -1) {
            classMinSdk = this.getMinSdk((Context)context);
        }
        if ((methodList = classNode.methods).isEmpty()) {
            return;
        }
        boolean checkCalls = context.isEnabled(UNSUPPORTED) || context.isEnabled(INLINED);
        boolean checkMethods = context.isEnabled(OVERRIDE) && context.getMainProject().getBuildSdk() >= 1;
        String frameworkParent = null;
        if (checkMethods) {
            LintDriver driver = context.getDriver();
            String owner = classNode.superName;
            while (owner != null) {
                if (owner.startsWith("android/") && !owner.startsWith("android/support/") || owner.startsWith("java/") || owner.startsWith("javax/")) {
                    frameworkParent = owner;
                    break;
                }
                owner = driver.getSuperClass(owner);
            }
            if (frameworkParent == null) {
                checkMethods = false;
            }
        }
        if (checkCalls) {
            if (classNode.superName != null) {
                String signature = classNode.superName;
                this.checkExtendsClass(context, classNode, classMinSdk, signature);
            }
            if (classNode.interfaces != null) {
                List interfaceList = classNode.interfaces;
                for (String signature : interfaceList) {
                    this.checkExtendsClass(context, classNode, classMinSdk, signature);
                }
            }
        }
        for (Object m : methodList) {
            MethodNode method = (MethodNode)m;
            int minSdk = ApiDetector.getLocalMinSdk(method.invisibleAnnotations);
            if (minSdk == -1) {
                minSdk = classMinSdk;
            }
            InsnList nodes = method.instructions;
            if (checkMethods && Character.isJavaIdentifierStart(method.name.charAt(0))) {
                int buildSdk = context.getMainProject().getBuildSdk();
                String name = method.name;
                assert (frameworkParent != null);
                int api = this.mApiDatabase.getCallVersion(frameworkParent, name, method.desc);
                if (api > buildSdk && buildSdk != -1) {
                    String owner = classNode.name;
                    String fqcn = "<init>".equals(name) ? "new " + ClassContext.getFqcn((String)owner) : ClassContext.getFqcn((String)owner) + '#' + name;
                    String message = String.format("This method is not overriding anything with the current build target, but will in API level %1$d (current target is %2$d): `%3$s`", api, buildSdk, fqcn);
                    Location location = context.getLocation(method, classNode);
                    context.report(OVERRIDE, method, null, location, message);
                }
            }
            if (!checkCalls) continue;
            int n = nodes.size();
            block3: for (int i = 0; i < n; ++i) {
                Type t;
                String className;
                int api;
                String owner;
                String name;
                MethodInsnNode node;
                AbstractInsnNode instruction = nodes.get(i);
                int type = instruction.getType();
                if (type == 5) {
                    node = (MethodInsnNode)instruction;
                    name = node.name;
                    owner = node.owner;
                    String desc = node.desc;
                    if (node.getOpcode() == 182 && owner.equals(classNode.name)) {
                        owner = classNode.superName;
                    }
                    boolean checkingSuperClass = false;
                    while (owner != null) {
                        int api2 = this.mApiDatabase.getCallVersion(owner, name, desc);
                        if (api2 > minSdk) {
                            if (method.name.startsWith(SWITCH_TABLE_PREFIX) || !checkingSuperClass && node.getOpcode() == 182 && ApiDetector.methodDefinedLocally(classNode, name, desc)) continue block3;
                            String fqcn = "<init>".equals(name) ? "new " + ClassContext.getFqcn((String)owner) : ClassContext.getFqcn((String)owner) + '#' + name;
                            String message = String.format("Call requires API level %1$d (current min is %2$d): `%3$s`", api2, minSdk, fqcn);
                            if (name.equals(ORDINAL_METHOD) && instruction.getNext() != null && instruction.getNext().getNext() != null && instruction.getNext().getOpcode() == 46 && instruction.getNext().getNext().getOpcode() == 170) {
                                message = String.format("Enum for switch requires API level %1$d (current min is %2$d): `%3$s`", api2, minSdk, ClassContext.getFqcn((String)owner));
                            }
                            ApiDetector.report(context, message, (AbstractInsnNode)node, method, name, null, Location.SearchHints.create((Location.SearchDirection)Location.SearchDirection.FORWARD).matchJavaSymbol());
                        }
                        if (owner.startsWith("android/") || owner.startsWith("javax/")) {
                            owner = owner.startsWith("android/support/") ? context.getDriver().getSuperClass(owner) : null;
                        } else if (owner.startsWith("java/")) {
                            if (owner.equals("java/text/SimpleDateFormat")) {
                                ApiDetector.checkSimpleDateFormat(context, method, node, minSdk);
                            }
                            owner = null;
                        } else {
                            owner = node.getOpcode() == 182 ? context.getDriver().getSuperClass(owner) : (node.getOpcode() == 184 && api2 == -1 ? context.getDriver().getSuperClass(owner) : null);
                        }
                        checkingSuperClass = true;
                    }
                    continue;
                }
                if (type == 4) {
                    node = (FieldInsnNode)instruction;
                    owner = node.owner;
                    name = node.name;
                    int api3 = this.mApiDatabase.getFieldVersion(owner, name);
                    if (api3 <= minSdk) continue;
                    if (method.name.startsWith(SWITCH_TABLE_PREFIX)) {
                        ApiDetector.checkSwitchBlock(context, classNode, (FieldInsnNode)node, method, name, owner, api3, minSdk);
                        continue;
                    }
                    if (ApiDetector.isSkippedEnumSwitch(context, classNode, method, (FieldInsnNode)node, owner, api3)) continue;
                    String fqcn = ClassContext.getFqcn((String)owner) + '#' + name;
                    if (this.mPendingFields != null) {
                        this.mPendingFields.remove(fqcn);
                    }
                    String message = String.format("Field requires API level %1$d (current min is %2$d): `%3$s`", api3, minSdk, fqcn);
                    ApiDetector.report(context, message, (AbstractInsnNode)node, method, name, null, Location.SearchHints.create((Location.SearchDirection)Location.SearchDirection.FORWARD).matchJavaSymbol());
                    continue;
                }
                if (type != 9) continue;
                node = (LdcInsnNode)instruction;
                if (!(node.cst instanceof Type) || (api = this.mApiDatabase.getClassVersion(className = (t = (Type)node.cst).getInternalName())) <= minSdk) continue;
                String fqcn = ClassContext.getFqcn((String)className);
                String message = String.format("Class requires API level %1$d (current min is %2$d): `%3$s`", api, minSdk, fqcn);
                ApiDetector.report(context, message, (AbstractInsnNode)node, method, className.substring(className.lastIndexOf(47) + 1), null, Location.SearchHints.create((Location.SearchDirection)Location.SearchDirection.FORWARD).matchJavaSymbol());
            }
        }
    }

    private void checkExtendsClass(ClassContext context, ClassNode classNode, int classMinSdk, String signature) {
        int api = this.mApiDatabase.getClassVersion(signature);
        if (api > classMinSdk) {
            String fqcn = ClassContext.getFqcn((String)signature);
            String message = String.format("Class requires API level %1$d (current min is %2$d): `%3$s`", api, classMinSdk, fqcn);
            String name = signature.substring(signature.lastIndexOf(47) + 1);
            name = name.substring(name.lastIndexOf(36) + 1);
            Location.SearchHints hints = Location.SearchHints.create((Location.SearchDirection)Location.SearchDirection.BACKWARD).matchJavaSymbol();
            int lineNumber = ClassContext.findLineNumber((ClassNode)classNode);
            Location location = context.getLocationForLine(lineNumber, name, null, hints);
            context.report(UNSUPPORTED, location, message);
        }
    }

    private static void checkSimpleDateFormat(ClassContext context, MethodNode method, MethodInsnNode node, int minSdk) {
        if (minSdk >= 9) {
            return;
        }
        if (node.name.equals("<init>") && !node.desc.equals("()V")) {
            AbstractInsnNode prev = LintUtils.getPrevInstruction((AbstractInsnNode)node);
            if (prev != null && !node.desc.equals("(Ljava/lang/String;)V")) {
                prev = LintUtils.getPrevInstruction((AbstractInsnNode)prev);
            }
            if (prev != null && prev.getOpcode() == 18) {
                LdcInsnNode ldc = (LdcInsnNode)prev;
                Object cst = ldc.cst;
                if (cst instanceof String) {
                    String pattern = (String)cst;
                    boolean isEscaped = false;
                    for (int i = 0; i < pattern.length(); ++i) {
                        char c = pattern.charAt(i);
                        if (c == '\'') {
                            isEscaped = !isEscaped;
                            continue;
                        }
                        if (isEscaped || c != 'L' && c != 'c') continue;
                        String message = String.format("The pattern character '%1$c' requires API level 9 (current min is %2$d) : \"`%3$s`\"", Character.valueOf(c), minSdk, pattern);
                        ApiDetector.report(context, message, (AbstractInsnNode)node, method, pattern, null, Location.SearchHints.create((Location.SearchDirection)Location.SearchDirection.FORWARD));
                        return;
                    }
                }
            }
        }
    }

    private static boolean methodDefinedLocally(ClassNode classNode, String name, String desc) {
        List methodList = classNode.methods;
        for (Object m : methodList) {
            MethodNode method = (MethodNode)m;
            if (!name.equals(method.name) || !desc.equals(method.desc)) continue;
            return true;
        }
        return false;
    }

    private static void checkSwitchBlock(ClassContext context, ClassNode classNode, FieldInsnNode field, MethodNode method, String name, String owner, int api, int minSdk) {
        int ordinal;
        AbstractInsnNode next = field.getNext();
        if (next == null || next.getOpcode() != 182) {
            return;
        }
        if ((next = next.getNext()) == null) {
            return;
        }
        switch (next.getOpcode()) {
            case 3: {
                ordinal = 0;
                break;
            }
            case 4: {
                ordinal = 1;
                break;
            }
            case 5: {
                ordinal = 2;
                break;
            }
            case 6: {
                ordinal = 3;
                break;
            }
            case 7: {
                ordinal = 4;
                break;
            }
            case 8: {
                ordinal = 5;
                break;
            }
            case 16: {
                IntInsnNode iin = (IntInsnNode)next;
                ordinal = iin.operand;
                break;
            }
            default: {
                return;
            }
        }
        List methodList = classNode.methods;
        for (Object m : methodList) {
            InsnList nodes = ((MethodNode)m).instructions;
            int n = nodes.size();
            block10: for (int i = 0; i < n; ++i) {
                AbstractInsnNode instruction = nodes.get(i);
                if (instruction.getOpcode() != 184) continue;
                MethodInsnNode node = (MethodInsnNode)instruction;
                if (!node.name.equals(method.name) || !node.desc.equals(method.desc) || !node.owner.equals(classNode.name)) continue;
                AbstractInsnNode target = LintUtils.getNextInstruction((AbstractInsnNode)node);
                while (target != null) {
                    if (target.getOpcode() == 171) {
                        LookupSwitchInsnNode lookup = (LookupSwitchInsnNode)target;
                        List keys = lookup.keys;
                        if (keys != null && keys.contains(ordinal)) {
                            String fqcn = ClassContext.getFqcn((String)owner) + '#' + name;
                            String message = String.format("Enum value requires API level %1$d (current min is %2$d): `%3$s`", api, minSdk, fqcn);
                            ApiDetector.report(context, message, (AbstractInsnNode)lookup, (MethodNode)m, name, null, Location.SearchHints.create((Location.SearchDirection)Location.SearchDirection.FORWARD).matchJavaSymbol());
                            continue block10;
                        }
                    }
                    target = LintUtils.getNextInstruction((AbstractInsnNode)target);
                }
            }
        }
    }

    private static boolean isEnumSwitchInitializer(ClassNode classNode) {
        List fieldList = classNode.fields;
        for (Object f : fieldList) {
            FieldNode field = (FieldNode)f;
            if (!field.name.startsWith(ENUM_SWITCH_PREFIX)) continue;
            return true;
        }
        return false;
    }

    private static MethodNode findEnumSwitchUsage(ClassNode classNode, String owner) {
        String target = ENUM_SWITCH_PREFIX + owner.replace('/', '$');
        List methodList = classNode.methods;
        for (Object f : methodList) {
            MethodNode method = (MethodNode)f;
            InsnList nodes = method.instructions;
            int n = nodes.size();
            for (int i = 0; i < n; ++i) {
                AbstractInsnNode instruction = nodes.get(i);
                if (instruction.getOpcode() != 178) continue;
                FieldInsnNode field = (FieldInsnNode)instruction;
                if (!field.name.equals(target)) continue;
                return method;
            }
        }
        return null;
    }

    private static boolean isSkippedEnumSwitch(ClassContext context, ClassNode classNode, MethodNode method, FieldInsnNode node, String owner, int api) {
        MethodNode switchUser;
        LintDriver driver;
        ClassNode outer;
        AbstractInsnNode next = LintUtils.getNextInstruction((AbstractInsnNode)node);
        if (next != null && next.getOpcode() == 182 && "<clinit>".equals(method.name) && ORDINAL_METHOD.equals(((MethodInsnNode)next).name) && classNode.outerClass != null && ApiDetector.isEnumSwitchInitializer(classNode) && (outer = (driver = context.getDriver()).getOuterClassNode(classNode)) != null && (switchUser = ApiDetector.findEnumSwitchUsage(outer, owner)) != null) {
            if (driver.isSuppressed(UNSUPPORTED, outer, switchUser, null)) {
                return true;
            }
            if (ApiDetector.getLocalMinSdk(switchUser.invisibleAnnotations) >= api || ApiDetector.getLocalMinSdk(outer.invisibleAnnotations) >= api) {
                return true;
            }
        }
        return false;
    }

    private static int getClassMinSdk(ClassContext context, ClassNode classNode) {
        int classMinSdk = ApiDetector.getLocalMinSdk(classNode.invisibleAnnotations);
        if (classMinSdk != -1) {
            return classMinSdk;
        }
        LintDriver driver = context.getDriver();
        while (classNode != null) {
            ClassNode prev = classNode;
            if ((classNode = driver.getOuterClassNode(classNode)) == null) continue;
            if (prev.outerMethod != null) {
                List methods = classNode.methods;
                for (Object m : methods) {
                    MethodNode method = (MethodNode)m;
                    if (!method.name.equals(prev.outerMethod) || !method.desc.equals(prev.outerMethodDesc)) continue;
                    int methodMinSdk = ApiDetector.getLocalMinSdk(method.invisibleAnnotations);
                    if (methodMinSdk == -1) break;
                    return methodMinSdk;
                }
            }
            if ((classMinSdk = ApiDetector.getLocalMinSdk(classNode.invisibleAnnotations)) == -1) continue;
            return classMinSdk;
        }
        return -1;
    }

    private static int getLocalMinSdk(List annotations) {
        if (annotations != null) {
            for (AnnotationNode annotation : annotations) {
                String desc = annotation.desc;
                if (!desc.endsWith(TARGET_API_VMSIG) || annotation.values == null) continue;
                int n = annotation.values.size();
                for (int i = 0; i < n; i += 2) {
                    Object value;
                    String key = (String)annotation.values.get(i);
                    if (!key.equals("value") || !((value = annotation.values.get(i + 1)) instanceof Integer)) continue;
                    return (Integer)value;
                }
            }
        }
        return -1;
    }

    private static int getLocalMinSdk(@NonNull Element element) {
        while (element != null) {
            String targetApi = element.getAttributeNS("http://schemas.android.com/tools", "targetApi");
            if (targetApi != null && !targetApi.isEmpty()) {
                if (Character.isDigit(targetApi.charAt(0))) {
                    try {
                        return Integer.parseInt(targetApi);
                    }
                    catch (NumberFormatException nufe) {
                        break;
                    }
                }
                return SdkVersionInfo.getApiByBuildCode((String)targetApi, (boolean)true);
            }
            org.w3c.dom.Node parent = element.getParentNode();
            if (parent == null || parent.getNodeType() != 1) break;
            element = (Element)parent;
        }
        return -1;
    }

    private static void report(ClassContext context, String message, AbstractInsnNode node, MethodNode method, String patternStart, String patternEnd, Location.SearchHints hints) {
        int lineNumber;
        int n = lineNumber = node != null ? ClassContext.findLineNumber((AbstractInsnNode)node) : -1;
        if (patternStart != null && patternStart.equals("<init>") && node instanceof MethodInsnNode) {
            if (hints != null) {
                hints = hints.matchConstructor();
            }
            patternStart = ((MethodInsnNode)node).owner;
        }
        if (patternStart != null) {
            int index = patternStart.lastIndexOf(36);
            if (index != -1) {
                patternStart = patternStart.substring(index + 1);
            }
            if ((index = patternStart.lastIndexOf(47)) != -1) {
                patternStart = patternStart.substring(index + 1);
            }
        }
        Location location = context.getLocationForLine(lineNumber, patternStart, patternEnd, hints);
        context.report(UNSUPPORTED, method, node, location, message);
    }

    public void afterCheckProject(@NonNull Context context) {
        if (this.mPendingFields != null) {
            for (List<Pair<String, Location>> list : this.mPendingFields.values()) {
                for (Pair<String, Location> pair : list) {
                    String message = (String)pair.getFirst();
                    Location location = (Location)pair.getSecond();
                    context.report(INLINED, location, message);
                }
            }
        }
        super.afterCheckProject(context);
    }

    @Nullable
    public AstVisitor createJavaVisitor(@NonNull JavaContext context) {
        if (this.mApiDatabase == null) {
            return new ForwardingAstVisitor(){};
        }
        return new ApiVisitor(context);
    }

    @Nullable
    public List<Class<? extends Node>> getApplicableNodeTypes() {
        ArrayList<Class<? extends Node>> types = new ArrayList<Class<? extends Node>>(2);
        types.add(ImportDeclaration.class);
        types.add(Select.class);
        types.add(MethodDeclaration.class);
        types.add(ConstructorDeclaration.class);
        types.add(VariableDefinitionEntry.class);
        types.add(VariableReference.class);
        types.add(Try.class);
        return types;
    }

    public static boolean isBenignConstantUsage(@Nullable Node node, @NonNull String name, @NonNull String owner) {
        if (owner.equals("android/os/Build$VERSION_CODES")) {
            return true;
        }
        if (owner.equals("android/view/ViewGroup$LayoutParams") && name.equals("MATCH_PARENT")) {
            return true;
        }
        if (owner.equals("android/widget/AbsListView") && (name.equals("CHOICE_MODE_NONE") || name.equals("CHOICE_MODE_MULTIPLE") || name.equals("CHOICE_MODE_SINGLE"))) {
            return true;
        }
        if ("android/view/Gravity".equals(owner) && ("START".equals(name) || "END".equals(name))) {
            return true;
        }
        if (node == null) {
            return false;
        }
        for (Node curr = node.getParent(); curr != null; curr = curr.getParent()) {
            Class<?> nodeType = curr.getClass();
            if (nodeType == Case.class) {
                Case caseStatement = (Case)curr;
                Expression condition = caseStatement.astCondition();
                return condition != null && ApiDetector.isAncestor((Node)condition, node);
            }
            if (nodeType == If.class) {
                If ifStatement = (If)curr;
                Expression condition = ifStatement.astCondition();
                return condition != null && ApiDetector.isAncestor((Node)condition, node);
            }
            if (nodeType != InlineIfExpression.class) continue;
            InlineIfExpression ifStatement = (InlineIfExpression)curr;
            Expression condition = ifStatement.astCondition();
            return condition != null && ApiDetector.isAncestor((Node)condition, node);
        }
        return false;
    }

    private static boolean isAncestor(@NonNull Node ancestor, @Nullable Node node) {
        while (node != null) {
            if (node == ancestor) {
                return true;
            }
            node = node.getParent();
        }
        return false;
    }

    public static int getTargetApi(@Nullable Modifiers modifiers) {
        if (modifiers == null) {
            return -1;
        }
        StrictListAccessor annotations = modifiers.astAnnotations();
        if (annotations == null) {
            return -1;
        }
        for (Annotation annotation : annotations) {
            StrictListAccessor values;
            TypeReference t = annotation.astAnnotationTypeReference();
            String typeName = t.getTypeName();
            if (!typeName.endsWith("TargetApi") || (values = annotation.astElements()) == null) continue;
            for (AnnotationElement element : values) {
                AnnotationValue valueNode = element.astValue();
                if (valueNode == null) continue;
                if (valueNode instanceof IntegralLiteral) {
                    IntegralLiteral literal = (IntegralLiteral)valueNode;
                    return literal.astIntValue();
                }
                if (valueNode instanceof StringLiteral) {
                    String value = ((StringLiteral)valueNode).astValue();
                    return SdkVersionInfo.getApiByBuildCode((String)value, (boolean)true);
                }
                if (valueNode instanceof Select) {
                    Select select = (Select)valueNode;
                    String codename = select.astIdentifier().astValue();
                    return SdkVersionInfo.getApiByBuildCode((String)codename, (boolean)true);
                }
                if (!(valueNode instanceof VariableReference)) continue;
                VariableReference reference = (VariableReference)valueNode;
                String codename = reference.astIdentifier().astValue();
                return SdkVersionInfo.getApiByBuildCode((String)codename, (boolean)true);
            }
        }
        return -1;
    }

    public static int getRequiredVersion(@NonNull Issue issue, @NonNull String errorMessage, @NonNull TextFormat format) {
        Pattern pattern;
        Matcher matcher;
        errorMessage = format.toText(errorMessage);
        if ((issue == UNSUPPORTED || issue == INLINED) && (matcher = (pattern = Pattern.compile("\\s(\\d+)\\s")).matcher(errorMessage)).find()) {
            return Integer.parseInt(matcher.group(1));
        }
        return -1;
    }

    private final class ApiVisitor
    extends ForwardingAstVisitor {
        private JavaContext mContext;
        private Map<String, String> mClassToImport = Maps.newHashMap();
        private List<String> mStarImports;
        private Set<String> mLocalVars;
        private Node mCurrentMethod;
        private Set<String> mFields;
        private List<String> mStaticStarImports;

        private ApiVisitor(JavaContext context) {
            this.mContext = context;
        }

        public boolean visitImportDeclaration(ImportDeclaration node) {
            if (node.astStarImport()) {
                String pkgName;
                String fqcn = node.asFullyQualifiedName();
                int strip = fqcn.lastIndexOf(42);
                if (strip != -1 && (strip = fqcn.lastIndexOf(46, strip)) != -1 && ApiLookup.isRelevantOwner(pkgName = ClassContext.getInternalName((String)fqcn.substring(0, strip)))) {
                    if (node.astStaticImport()) {
                        if (this.mStaticStarImports == null) {
                            this.mStaticStarImports = Lists.newArrayList();
                        }
                        this.mStaticStarImports.add(pkgName);
                    } else {
                        if (this.mStarImports == null) {
                            this.mStarImports = Lists.newArrayList();
                        }
                        this.mStarImports.add(pkgName);
                    }
                }
            } else if (node.astStaticImport()) {
                String fqcn = node.asFullyQualifiedName();
                String fieldName = ClassContext.getInternalName((String)fqcn);
                int index = fieldName.lastIndexOf(36);
                if (index != -1) {
                    String owner = fieldName.substring(0, index);
                    String name = fieldName.substring(index + 1);
                    this.checkField((Node)node, name, owner);
                }
            } else {
                String fqcn = node.asFullyQualifiedName();
                int last = fqcn.lastIndexOf(46);
                if (last != -1) {
                    String className = fqcn.substring(last + 1);
                    this.mClassToImport.put(className, fqcn);
                }
            }
            return super.visitImportDeclaration(node);
        }

        public boolean visitSelect(Select node) {
            boolean result = super.visitSelect(node);
            if (node.getParent() instanceof Select) {
                return result;
            }
            String name = node.astIdentifier().astValue();
            boolean isField = Character.isUpperCase(name.charAt(0));
            if (!isField) {
                Select current = node;
                while (current != null) {
                    VariableReference reference;
                    Expression operand = current.astOperand();
                    if (operand instanceof Select) {
                        current = (Select)operand;
                        if (!"R".equals(current.astIdentifier().astValue())) continue;
                        isField = true;
                        break;
                    }
                    if (!(operand instanceof VariableReference) || !"R".equals((reference = (VariableReference)operand).astIdentifier().astValue())) break;
                    isField = true;
                    break;
                }
            }
            if (isField) {
                Expression operand = node.astOperand();
                if (operand.getClass() == Select.class) {
                    int firstDot;
                    String cls = operand.toString();
                    if (Character.isUpperCase(cls.charAt(0)) && (firstDot = cls.indexOf(46)) != -1) {
                        String base = cls.substring(0, firstDot);
                        String fqcn = this.mClassToImport.get(base);
                        if (fqcn != null) {
                            String owner = ClassContext.getInternalName((String)(fqcn + cls.substring(firstDot)));
                            this.checkField((Node)node, name, owner);
                            return result;
                        }
                        if (this.mStarImports != null) {
                            for (String packagePrefix : this.mStarImports) {
                                String owner = ClassContext.getInternalName((String)(packagePrefix + '/' + cls));
                                if (!this.checkField((Node)node, name, owner)) continue;
                                this.mClassToImport.put(name, owner);
                                return result;
                            }
                        }
                    }
                    String owner = ClassContext.getInternalName((String)cls);
                    this.checkField((Node)node, name, owner);
                    return result;
                }
                if (operand.getClass() == VariableReference.class) {
                    String className = ((VariableReference)operand).astIdentifier().astValue();
                    String fqcn = this.mClassToImport.get(className);
                    if (fqcn != null) {
                        String owner = ClassContext.getInternalName((String)fqcn);
                        this.checkField((Node)node, name, owner);
                        return result;
                    }
                    if (Character.isUpperCase(className.charAt(0)) && this.mStarImports != null) {
                        for (String packagePrefix : this.mStarImports) {
                            String owner = ClassContext.getInternalName((String)packagePrefix) + '/' + className;
                            if (!this.checkField((Node)node, name, owner)) continue;
                            this.mClassToImport.put(name, owner);
                            return result;
                        }
                    }
                }
            }
            return result;
        }

        public boolean visitVariableReference(VariableReference node) {
            boolean result;
            block5: {
                String name;
                result = super.visitVariableReference(node);
                if (node.getParent() != null) {
                    BinaryExpression expression;
                    Node parent = node.getParent();
                    Class<?> parentClass = parent.getClass();
                    if (parentClass == Select.class || parentClass == Switch.class || parentClass == Case.class || parentClass == ConstructorInvocation.class || parentClass == SuperConstructorInvocation.class || parentClass == AnnotationElement.class) {
                        return result;
                    }
                    if (parent instanceof MethodInvocation && ((MethodInvocation)parent).astOperand() == node) {
                        return result;
                    }
                    if (parent instanceof BinaryExpression && (expression = (BinaryExpression)parent).astLeft() == node) {
                        return result;
                    }
                }
                if (!Character.isUpperCase((name = node.astIdentifier().astValue()).charAt(0)) || this.mLocalVars != null && this.mLocalVars.contains(name) || this.mFields != null && this.mFields.contains(name) || this.mStaticStarImports == null) break block5;
                for (String owner : this.mStaticStarImports) {
                    if (this.checkField((Node)node, name, owner)) break;
                }
            }
            return result;
        }

        public boolean visitVariableDefinitionEntry(VariableDefinitionEntry node) {
            if (this.mCurrentMethod != null) {
                if (this.mLocalVars == null) {
                    this.mLocalVars = Sets.newHashSet();
                }
                this.mLocalVars.add(node.astName().astValue());
            } else {
                if (this.mFields == null) {
                    this.mFields = Sets.newHashSet();
                }
                this.mFields.add(node.astName().astValue());
            }
            return super.visitVariableDefinitionEntry(node);
        }

        public boolean visitMethodDeclaration(MethodDeclaration node) {
            this.mLocalVars = null;
            this.mCurrentMethod = node;
            return super.visitMethodDeclaration(node);
        }

        public boolean visitConstructorDeclaration(ConstructorDeclaration node) {
            this.mLocalVars = null;
            this.mCurrentMethod = node;
            return super.visitConstructorDeclaration(node);
        }

        public boolean visitTry(Try node) {
            block8: {
                block9: {
                    Object nativeNode = node.getNativeNode();
                    if (nativeNode == null || !nativeNode.getClass().getName().equals("org.eclipse.jdt.internal.compiler.ast.TryStatement")) break block8;
                    boolean isTryWithResources = false;
                    try {
                        Field field = nativeNode.getClass().getDeclaredField("resources");
                        Object value = field.get(nativeNode);
                        if (value instanceof Object[]) {
                            Object[] resources = (Object[])value;
                            isTryWithResources = resources.length > 0;
                        }
                    }
                    catch (NoSuchFieldException e) {
                    }
                    catch (IllegalAccessException e) {
                        // empty catch block
                    }
                    if (!isTryWithResources) break block9;
                    int api = 19;
                    int minSdk = ApiDetector.this.getMinSdk((Context)this.mContext);
                    if (api <= minSdk || api <= this.getLocalMinSdk((Node)node)) break block8;
                    Location location = this.mContext.getLocation((Node)node);
                    String message = String.format("Try-with-resources requires API level %1$d (current min is %2$d)", api, minSdk);
                    LintDriver driver = this.mContext.getDriver();
                    if (driver.isSuppressed(this.mContext, UNSUPPORTED, (Node)node)) break block8;
                    this.mContext.report(UNSUPPORTED, location, message);
                    break block8;
                }
                for (Catch c : node.astCatches()) {
                    int minSdk;
                    String owner;
                    int api;
                    VariableDefinition variableDefinition = c.astExceptionDeclaration();
                    TypeReference typeReference = variableDefinition.astTypeReference();
                    String fqcn = null;
                    JavaParser.ResolvedNode resolved = this.mContext.resolve((Node)typeReference);
                    if (resolved != null) {
                        fqcn = resolved.getSignature();
                    } else if (typeReference.getTypeName().equals("ReflectiveOperationException")) {
                        fqcn = "java.lang.ReflectiveOperationException";
                    }
                    if (fqcn == null || (api = ApiDetector.this.mApiDatabase.getClassVersion(owner = ClassContext.getInternalName((String)fqcn))) <= (minSdk = ApiDetector.this.getMinSdk((Context)this.mContext)) || api <= this.getLocalMinSdk((Node)typeReference)) continue;
                    Location location = this.mContext.getLocation((Node)typeReference);
                    String message = String.format("Class requires API level %1$d (current min is %2$d): `%3$s`", api, minSdk, fqcn);
                    LintDriver driver = this.mContext.getDriver();
                    if (driver.isSuppressed(this.mContext, UNSUPPORTED, (Node)typeReference)) continue;
                    this.mContext.report(UNSUPPORTED, location, message);
                }
            }
            return super.visitTry(node);
        }

        public void endVisit(Node node) {
            if (node == this.mCurrentMethod) {
                this.mCurrentMethod = null;
            }
            super.endVisit(node);
        }

        private boolean checkField(@NonNull Node node, @NonNull String name, @NonNull String owner) {
            int api = ApiDetector.this.mApiDatabase.getFieldVersion(owner, name);
            if (api != -1) {
                int minSdk = ApiDetector.this.getMinSdk((Context)this.mContext);
                if (api > minSdk && api > this.getLocalMinSdk(node)) {
                    ArrayList<Pair> list;
                    if (ApiDetector.isBenignConstantUsage(node, name, owner)) {
                        return true;
                    }
                    Location location = this.mContext.getLocation(node);
                    String fqcn = ClassContext.getFqcn((String)owner) + '#' + name;
                    if (node instanceof ImportDeclaration) {
                        ImportDeclaration d = (ImportDeclaration)node;
                        int startOffset = ((Identifier)d.astParts().first()).getPosition().getStart();
                        Position start = location.getStart();
                        int startColumn = start.getColumn();
                        int startLine = start.getLine();
                        start = new DefaultPosition(startLine, startColumn + startOffset - start.getOffset(), startOffset);
                        int fqcnLength = fqcn.length();
                        DefaultPosition end = new DefaultPosition(startLine, start.getColumn() + fqcnLength, start.getOffset() + fqcnLength);
                        location = Location.create((File)location.getFile(), (Position)start, (Position)end);
                    }
                    String message = String.format("Field requires API level %1$d (current min is %2$d): `%3$s`", api, minSdk, fqcn);
                    LintDriver driver = this.mContext.getDriver();
                    if (driver.isSuppressed(this.mContext, INLINED, node)) {
                        return true;
                    }
                    if (driver.isSuppressed(this.mContext, UNSUPPORTED, node)) {
                        return true;
                    }
                    if (ApiDetector.this.mPendingFields == null) {
                        ApiDetector.this.mPendingFields = Maps.newHashMapWithExpectedSize((int)20);
                    }
                    if ((list = (ArrayList<Pair>)ApiDetector.this.mPendingFields.get(fqcn)) == null) {
                        list = new ArrayList<Pair>();
                        ApiDetector.this.mPendingFields.put(fqcn, list);
                    } else {
                        for (Pair pair : list) {
                            Location existingLocation = (Location)pair.getSecond();
                            if (!location.getFile().equals(existingLocation.getFile())) continue;
                            Position start = location.getStart();
                            Position existingStart = existingLocation.getStart();
                            if (start == null || existingStart == null || start.getLine() != existingStart.getLine()) continue;
                            return true;
                        }
                    }
                    list.add(Pair.of((Object)message, (Object)location));
                }
                return true;
            }
            return false;
        }

        public int getLocalMinSdk(@Nullable Node scope) {
            while (scope != null) {
                VariableDefinition declaration;
                int targetApi;
                Class<?> type = scope.getClass();
                if (type == VariableDefinition.class ? (targetApi = ApiDetector.getTargetApi((declaration = (VariableDefinition)scope).astModifiers())) != -1 : (type == MethodDeclaration.class ? (targetApi = ApiDetector.getTargetApi((declaration = (MethodDeclaration)scope).astModifiers())) != -1 : (type == ConstructorDeclaration.class ? (targetApi = ApiDetector.getTargetApi((declaration = (ConstructorDeclaration)scope).astModifiers())) != -1 : type == ClassDeclaration.class && (targetApi = ApiDetector.getTargetApi((declaration = (ClassDeclaration)scope).astModifiers())) != -1))) {
                    return targetApi;
                }
                scope = scope.getParent();
            }
            return -1;
        }
    }
}

