package com.atlassian.user;

import com.atlassian.user.repository.RepositoryIdentifier;

public interface EntityManager
{
    /**
     * @return the {@link RepositoryIdentifier} for the repository which is managed by this instance.
     */
    RepositoryIdentifier getIdentifier();

    /**
     * @return the {@link RepositoryIdentifier} of the repository in which the entity is stored, or <tt>null</tt>
     * if the entity cannot be found.
     * @throws EntityException if the entity cannot be found, or trying to retrieve it results in an error
     */
    RepositoryIdentifier getRepository(Entity entity) throws EntityException;

    /**
     * Used to detemine whether an entity can be created (eg, can call {@link UserManager#createUser(String)} or
     * {@link GroupManager#createGroup(String)}.
     *
     * @return true to indicate that {@link Entity} objects can be created by this manager, or false to indicate
     * not. 
     */
    boolean isCreative();
}
