package com.atlassian.user.configuration;

import com.atlassian.user.impl.ldap.repository.LdapContextFactory;

/**
 * Top level interface representing the Configuration between a client and Atlassian User.
 *
 * The delegation can be accessed via {@link Configuration#getDelegationAccessor()}, once {@link Configuration#init()}
 * has been called.
 */

public interface Configuration
{
    final String DELEGATION = "delegation";

    final String PROCESSOR = "processor";
    final String CLASSES = "classes";

    final String HIBERNATE = "hibernate";
    final String LDAP = "ldap";
    final String OSUSER = "osuser";
    final String MEMORY = "memory";

    final String DEFAULT = "default";
    final String PARAM = "param";

    final String REPOSITORIES = "repositories";
    final String REPOSITORY = "repository";
    final String CLASS = "class";
    final String AUTHENTICATOR = "authenticator";
    final String USERMANAGER = "userManager";
    final String GROUPMANAGER = "groupManager";
    final String PASSWORD_ENCRYPTOR = "passwordEncryptor";
    final String PROPERTYSET_FACTORY = "propertySetFactory";
    final String CACHEFACTORY = "cacheFactory";

    final String USERFACTORY = "userFactory";
    final String USERADAPTOR = "userAdaptor";
    final String GROUPFACTORY = "groupFactory";
    final String GROUPADAPTOR = "groupAdaptor";

    final String ENTITY_QUERY_PARSER = "entityQueryParser";

    final String EXTERNAL_ENTITY_DAO = "externalEntityDAO";

    //Hibernate elements
    final String HIBERNATE_CONFIGURATION_PROVIDER = "configurationProvider";
    final String HIBERNATE_SESSION_FACTORY = "sessionFactory";
    final String ACCESSOR = "accessor";

    //OSUser elements
    final String OSU_CREDENTIALS_PROVIDER = "credentialsProvider";
    final String OSU_AUTHENTICATOR = AUTHENTICATOR;
    final String OSU_PROFILE_PROVIDER = "profileProvider";
    final String OSU_ACCESS_PROVIDER = "accessProvider";
    final String OSU_CREDENTIALS_PROVIDER_LIST = "credentialsProviderList";

    //External entity elements
    final String EXTERNAL_REPOSITORY = "externalRepository";

    //LDAP connection pool
    final String MAXSIZE = "maxSize";
    final String INITSIZE = "initSize";
    final String PREFSIZE = "prefSize";
    final String DEBUG = "debugLevel";
    final String SECURITY_PROTOCOL = "securityProtocol";
    final String AUTHENTICATION = "authentication";
    final String TIMEOUT = "timeout";
    final String TRUSTSTORE = "trustStore";

    //LDAP server
    final String SERVER = "server";
    final String HOST = LdapContextFactory.HOST;
    final String PORT = LdapContextFactory.PORT;
    final String SECURITY_PRINCIPAL = LdapContextFactory.SECURITY_PRINCIPAL;
    final String SECURITY_CREDENTIAL = LdapContextFactory.SECURITY_CREDENTIAL;
    final String BASE_CONTEXT = "baseContext";
    final String TIME_TO_LIVE = LdapContextFactory.TIME_TO_LIVE;
    final String BATCH_SIZE = "batchSize";
    final String POOLING_ON = "poolingOn";
    final String INITIAL_CONTEXT_FACTORY_JNDI = "initialContextFactory";

    final String LDAP_SCHEMA_MAPPINGS_PROPERTIES = "schemaMappings";
    final String LDAP_CONNECTION_POOL_PROPERTIES = "connectionPool";

    //LDAP entity mappings
    final String MAPPINGS = "mappings";
    final String BASE_USER_NAMESPACE = LdapContextFactory.BASE_USER_NAMESPACE;
    final String BASE_GROUP_NAMESPACE = LdapContextFactory.BASE_GROUP_NAMESPACE;
    final String USERNAME_ATTRIBUTE = LdapContextFactory.USERNAME_ATTRIBUTE;
    final String USER_SEARCH_FILTER = LdapContextFactory.USER_SEARCH_FILTER;
    final String GROUP_SEARCH_FILTER = LdapContextFactory.GROUP_SEARCH_FILTER;
    final String FIRSTNAME_ATTRIBUTE = LdapContextFactory.FIRSTNAME_ATTRIBUTE;
    final String SURNAME_ATTRIBUTE = LdapContextFactory.SURNAME_ATTRIBUTE;
    final String EMAIL_ATTRIBUTE = LdapContextFactory.EMAIL_ATTRIBUTE;
    final String GROUPNAME_ATTRIBUTE = LdapContextFactory.GROUPNAME_ATTRIBUTE;
    final String MEMBERSHIP_ATTRIBUTE = LdapContextFactory.MEMBERSHIP_ATTRIBUTE;
    final String USER_SEARCH_ALL_DEPTHS = LdapContextFactory.USER_SEARCH_ALL_DEPTHS;
    final String GROUP_SEARCH_ALL_DEPTHS = LdapContextFactory.GROUP_SEARCH_ALL_DEPTHS;
    final String USE_UNQUALIFIED_USER_NAME_FOR_MEMBERSHIP_COMPARISON = LdapContextFactory.USE_UNQUALIFIED_USER_NAME_FOR_MEMBERSHIP_COMPARISON;

    final String ORDER = "order";
    final String KEY = "key";
    final String NAME = "name";
    final String DESCRIPTION = "description";
    final String CACHE = "cache";
    public final String POOL_AUTHENTICATION = "poolAuthentication";
    final String PROVIDER_URL = "providerUrl";

    /**
     * @return a {@link RepositoryAccessor} holding all configured components.
     */
    DelegationAccessor getDelegationAccessor();

    void init() throws ConfigurationException;

    boolean isInitialized();
}

