package com.atlassian.user.configuration;

import com.atlassian.user.repository.RepositoryIdentifier;

import java.util.Map;
import java.util.Set;
import java.util.Collections;

import org.apache.log4j.Logger;

public class DefaultRepositoryConfiguration implements RepositoryConfiguration
{
    protected final Logger logger = Logger.getLogger(getClass());
    private final RepositoryIdentifier identifier;
    private final RepositoryProcessor processor;
    private final Map components;
    private final Map componentClassNames;
    private CacheConfiguration cacheConfiguration;

    public DefaultRepositoryConfiguration(RepositoryIdentifier identifier, RepositoryProcessor processor, Map components, Map componentClassNames)
    {
        this.identifier = identifier;
        this.processor = processor;
        this.components = components;
        this.componentClassNames = componentClassNames;
    }

    public void addComponent(String componentName, Object component)
    {
        if (hasComponent(componentName))
            logger.info("Overwriting existing component with name [" + componentName + "]");
        components.put(componentName, component);
    }

    public Object getComponent(String componentName)
    {
        return components.get(componentName);
    }

    public boolean hasComponent(String componentName)
    {
        return components.containsKey(componentName) && components.get(componentName) != null;
    }

    public String getComponentClassName(String componentName)
    {
        return (String) componentClassNames.get(componentName);
    }

    public RepositoryAccessor configure() throws ConfigurationException
    {
        return processor.process(this);
    }

    public RepositoryIdentifier getIdentifier()
    {
        return identifier;
    }

    public boolean hasClassForComponent(String componentName)
    {
        return componentClassNames.containsKey(componentName);
    }

    public Set getComponentNames()
    {
        return Collections.unmodifiableSet(components.keySet());
    }

    public void setCacheConfiguration(CacheConfiguration cacheConfiguration)
    {
        this.cacheConfiguration = cacheConfiguration;
    }

    public boolean isCachingEnabled()
    {
        return cacheConfiguration != null;
    }

    public CacheConfiguration getCacheConfiguration()
    {
        return cacheConfiguration;
    }
}
