package com.atlassian.user.configuration;

import java.util.List;

/**
 * Given to an application to access the delegation of repositories.
 */
public interface DelegationAccessor extends RepositoryAccessor
{
    /**
     * @return the {@link RepositoryAccessor} for the repository with the specified key, or <tt>null</tt> if
     * no repository exists for the given key.
     */
    RepositoryAccessor getRepositoryAccessor(String key);

    /**
     * @return a list of {@link RepositoryAccessor}s in the order of delegation.
     */
    List getRepositoryAccessors();

    /**
     * Adds a {@link RepositoryAccessor} to the end of the delegation order.
     */
    void addRepositoryAccessor(RepositoryAccessor accessor);
}
