package com.atlassian.user.configuration.xml;

import org.dom4j.Element;
import org.dom4j.Attribute;

import java.util.HashMap;
import java.util.List;
import java.util.Iterator;
import java.util.Map;

import com.atlassian.user.configuration.Configuration;

/**
 * Some XML-related functions shared by the config parser classes
 */
final class XMLConfigUtil
{
    ///CLOVER:OFF
    /** Do not construct me. */
    private XMLConfigUtil()
    {
    }
    ///CLOVER:ON

    /**
     * Parses all elements, which are assumed to be holding Strings representing classes to instantiate, and stores them
     * as key/value pairs in the HashMap.
     *
     * @param repositoryElement the XML element defining the repository.
     * @return {@link java.util.HashMap} of key/value pairs representing the classes to instantiate.
     */
    public static HashMap parseRepositoryElementForClassNames(Element repositoryElement)
    {
        HashMap values = new HashMap();
        Element classesElement = repositoryElement.element(Configuration.CLASSES);

        if (classesElement == null)
            return values;

        List subElements = classesElement.elements();
        Iterator iter = subElements.iterator();

        while (iter.hasNext())
        {
            Element element = (Element) iter.next();

            if (element.getName().equals(Configuration.PARAM))
            {
                Attribute paramAttribute = element.attribute(Configuration.NAME);
                values.put(paramAttribute.getText(), element.getText());
            }
            else
                values.put(element.getName(), element.getText());
        }

        Attribute attr = repositoryElement.attribute(Configuration.CLASS);

        if (attr != null)
        {
            values.put(Configuration.CLASS, attr.getText());
        }

        return values;
    }

    /**
     * Returns a hashmap of attribute values on the repository element, and child elements of the repository element
     * with their text content except for the 'classes' element.
     *
     * @param repositoryElement the XML element defining the repository.
     * @return {@link HashMap} of key/value pairs representing String data to be directly copied into the object.
     */
    public static Map parseRepositoryElementForStringData(Element repositoryElement)
    {
        HashMap values = new HashMap();

        Iterator attributeIterator = repositoryElement.attributes().iterator();
        while (attributeIterator.hasNext())
        {
            Attribute attr = (Attribute) attributeIterator.next();

            if (attr.getName().equals(Configuration.CLASS))
                continue;

            values.put(attr.getName(), attr.getText());
        }

        Iterator elementIterator = repositoryElement.elements().iterator();
        while (elementIterator.hasNext())
        {
            Element element = (Element) elementIterator.next();

            if (element.getName().equals(Configuration.CLASSES))
                continue;

            values.put(element.getName(), element.getText());
        }

        return values;
    }

}
