package com.atlassian.user.impl.cache;

import com.atlassian.user.User;
import com.atlassian.cache.*;

import java.util.List;
import java.util.Iterator;

/**
 * The groups-for-user cache is a cache where the key is the username as a
 * {@link String} and the value is a {@link java.util.List} of group names as
 * {@link String}s.
 *
 * @see CachingGroupManager
 */
public class GroupsForUserCache
{
    private final CacheFactory cacheFactory;
    private final String cacheName;

    public GroupsForUserCache(CacheFactory cacheFactory, String cacheName)
    {
        this.cacheFactory = cacheFactory;
        this.cacheName = cacheName;
    }

    private com.atlassian.cache.Cache getCache()
    {
        return cacheFactory.getCache(cacheName);
    }

    public void put(User user, List/*<String>*/ groupNames)
    {
        getCache().put(user.getName(), groupNames);
    }

    public List/*<String>*/ get(User user)
    {
        return (List) getCache().get(user.getName());
    }

    /**
     * Remove the cached list of groups for a particular user from
     * the cache. Typically used when the membership of a user has
     * been updated, so the cached list of groups is out of date.
     * <p/>
     * It's not very efficient to iterate over the list and
     * remove the affected groups, so we just ditch the entire
     * cached list.
     */
    public void remove(User user)
    {
        getCache().remove(user.getName());
    }

    /**
     * Remove a list of users from the cache by username. Typically
     * used when a group has been removed, and all its members need
     * to have their cached groups cleared.
     */
    public void remove(List/*<String>*/ usernames)
    {
        for (Iterator iter = usernames.iterator(); iter.hasNext();)
        {
            String username = (String) iter.next();
            getCache().remove(username);
        }
    }
}
