package com.atlassian.user.impl.delegation.properties;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.properties.PropertySetFactory;
import com.atlassian.util.profiling.UtilTimerStack;
import com.opensymphony.module.propertyset.PropertySet;

import java.util.List;
import java.util.Collections;

/**
 * A propertyset factory implementation which delegates out to
 * a number of propertyset factories
 */

public class DelegatingPropertySetFactory implements PropertySetFactory
{
    private final List propertySetFactories;

    public DelegatingPropertySetFactory(List propertySetFactories)
    {
        this.propertySetFactories = propertySetFactories;
    }

    public PropertySet getPropertySet(Entity entity) throws EntityException
    {
        if (UtilTimerStack.isActive())
            UtilTimerStack.push(this.getClass().getName() + "_delegating_getPropertySet(" + entity.getName() + ")");

        for (int i = 0; i < propertySetFactories.size(); i++)
        {
            PropertySetFactory setFactory = (PropertySetFactory) propertySetFactories.get(i);
            PropertySet propertySet = setFactory.getPropertySet(entity);
            if (propertySet != null)
            {
                if (UtilTimerStack.isActive())
                    UtilTimerStack.pop(this.getClass().getName() + "_delegating_getPropertySet(" + entity.getName() + ")");

                return propertySet;
            }
        }

        if (UtilTimerStack.isActive())
            UtilTimerStack.pop(this.getClass().getName() + "_delegating_getPropertySet(" + entity.getName() + ")");

        return null;
    }

    public List getPropertySetFactories()
    {
        return Collections.unmodifiableList(propertySetFactories);
    }
}
