package com.atlassian.user.impl.hibernate;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.user.cache.CacheFactoryAware;
import com.atlassian.user.ExternalEntity;

public class CachingExternalEntityDAO extends DefaultExternalEntityDAO implements CacheFactoryAware
{
    private CacheFactory cacheFactory;

    public void setCacheFactory(final CacheFactory cacheFactory)
    {
        this.cacheFactory = cacheFactory;
    }

    public ExternalEntity getExternalEntity(final String externalEntityName)
    {
        Cache nameCache = cacheFactory.getCache(this.getClass().getName() + ".externalEntityName");
        Long id = (Long) nameCache.get(externalEntityName);
        if (id != null)
            return (ExternalEntity) getHibernateTemplate().get(DefaultHibernateExternalEntity.class, id);

        ExternalEntity externalEntity = super.getExternalEntity(externalEntityName);
        if (externalEntity != null)
            nameCache.put(externalEntityName, new Long(externalEntity.getId()));

        return externalEntity;
    }

    public void removeExternalEntity(final String externalEntityName)
    {
        Cache nameCache = cacheFactory.getCache(this.getClass().getName() + ".externalEntityName");
        nameCache.remove(externalEntityName);
        super.removeExternalEntity(externalEntityName);
    }
}
