package com.atlassian.user.impl.hibernate;

import com.atlassian.user.impl.DefaultUser;

import java.util.Iterator;
import java.util.Set;

/**
 * A hibernate implementation of a user.
 *
 * This implementation is intended to provide a collection of groups this user
 * is a member of.  Care should taken when using this collection however as its
 * lazy loaded you must be sure you are querying it within the same session this
 * object was loaded.
 *
 * If unsure, use the {@link com.atlassian.user.GroupManager#getGroups(com.atlassian.user.User)} method.
 *
 * See: http://jira.atlassian.com/browse/USER-191
 */
public class DefaultHibernateUser extends DefaultUser
{
    private transient Set groups;
    // we depend on the fact that id is NOT-transient
    private long id;

    public DefaultHibernateUser(){}

    public DefaultHibernateUser(String name)
    {
        super(name);
    }

    /**
     * Provided for Hibernate's use only.
     *
     * @see com.atlassian.user.GroupManager#getGroups(com.atlassian.user.User)
     */
    public Set getGroups()
    {
        return groups;
    }

    public void setGroups(Set groups)
    {
        this.groups = groups;
    }

    public long getId()
    {
        return id;
    }

    public void setId(long id)
    {
        this.id = id;
    }

    public boolean equals(Object o)
    {
        if (this == o) return true;
        if (!(o instanceof DefaultHibernateUser)) return false;
        if (!super.equals(o)) return false;

        final DefaultHibernateUser defaultHibernateUser = (DefaultHibernateUser) o;

        return id == defaultHibernateUser.id;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer("id:").append(id).
                append(" name:").append(name).
                append(" fullName:").append(fullName).
                append(" email:").append(email).
                append(" created:").append(created);
        return ret.toString();
    }

    public int hashCode()
    {
        int result = super.hashCode();
        result = 29 * result + (int) (id ^ (id >>> 32));
        return result;
    }
}
