package com.atlassian.user.impl.hibernate.repository;

import com.opensymphony.module.propertyset.hibernate.HibernateConfigurationProvider;
import net.sf.hibernate.SessionFactory;

public class DefaultHibernateRepository implements HibernateRepository
{
    protected transient HibernateConfigurationProvider hibernateConfigProvider;
    protected transient SessionFactory sessionFactory;

    public DefaultHibernateRepository(HibernateConfigurationProvider hibernateConfigProvider,
                                      SessionFactory sessionFactory)
    {
        this.hibernateConfigProvider = hibernateConfigProvider;
        this.sessionFactory = sessionFactory;
    }

    public HibernateConfigurationProvider getHibernateConfigurationProvider()
    {
        return hibernateConfigProvider;
    }

    public SessionFactory getSessionFactory()
    {
        return sessionFactory;
    }
}
