package com.atlassian.user.impl.ldap.properties.factory;

import com.atlassian.user.impl.ldap.properties.LdapConnectionProperties;
import com.atlassian.user.impl.ldap.properties.DefaultLdapConnectionProperties;
import com.atlassian.user.configuration.Configuration;

import java.util.Properties;

import org.apache.log4j.Logger;

public class LdapConnectionPropertiesFactory
{
    protected final Logger log = Logger.getLogger(this.getClass());

    public LdapConnectionProperties createInstance(Properties properties)
    {
        DefaultLdapConnectionProperties result = new DefaultLdapConnectionProperties();
        result.setHost(properties.getProperty(Configuration.HOST, "localhost"));
        result.setJndiInitialContextFactoryIdentifier(
            properties.getProperty(Configuration.INITIAL_CONTEXT_FACTORY_JNDI));
        String port = properties.getProperty(Configuration.PORT, Integer.toString(DefaultLdapConnectionProperties.DEFAULT_LDAP_PORT));
        try
        {
            result.setPort(Integer.parseInt(port));
        }
        catch (NumberFormatException e)
        {
            log.warn("Error parsing LDAP server port in configuration file, using default value", e);
        }
        String batchSize = properties.getProperty(Configuration.BATCH_SIZE, Integer.toString(DefaultLdapConnectionProperties.DEFAULT_BATCH_SIZE));
        try
        {
            result.setSearchBatchSize(Integer.parseInt(batchSize));
        }
        catch (NumberFormatException e)
        {
            log.warn("Error parsing LDAP search batch size in configuration file, using default value", e);
        }
        result.setSecurityAuthentication(properties.getProperty(Configuration.AUTHENTICATION, DefaultLdapConnectionProperties.DEFAULT_AUTHENTICATION));
        result.setSecurityCredential(properties.getProperty(Configuration.SECURITY_CREDENTIAL));
        result.setSecurityPrincipal(properties.getProperty(Configuration.SECURITY_PRINCIPAL));
        result.setSecurityProtocol(properties.getProperty(Configuration.SECURITY_PROTOCOL));
        String poolingOn = properties.getProperty(Configuration.POOLING_ON, "true");
        result.setPoolingOn(Boolean.valueOf(poolingOn).booleanValue());
        result.setProviderURL(properties.getProperty(Configuration.PROVIDER_URL));
        return result;
    }
}
