package com.atlassian.user.impl.ldap.properties.factory;

import com.atlassian.user.impl.ldap.properties.LdapMembershipProperties;
import com.atlassian.user.impl.ldap.properties.DefaultLdapMembershipProperties;
import com.atlassian.user.configuration.Configuration;

import java.util.Properties;

public class LdapMembershipPropertiesFactory
{
    public LdapMembershipProperties createInstance(Properties properties)
    {
        DefaultLdapMembershipProperties result = new DefaultLdapMembershipProperties();
        result.setMembershipAttribute(properties.getProperty(Configuration.MEMBERSHIP_ATTRIBUTE));

        String membershipAttributeOnGroup = properties.getProperty("staticGroups");
        result.setMembershipAttributeOnGroup(Boolean.valueOf(membershipAttributeOnGroup).booleanValue());

        String membershipAttributeUnqualified =
            properties.getProperty(Configuration.USE_UNQUALIFIED_USER_NAME_FOR_MEMBERSHIP_COMPARISON);
        result.setMembershipAttributeUnqualified(Boolean.valueOf(membershipAttributeUnqualified).booleanValue());

        return result;
    }
}
