package com.atlassian.user.impl.ldap.properties.factory;

import com.atlassian.user.configuration.Configuration;
import com.atlassian.user.impl.ldap.properties.DefaultLdapSearchProperties;
import com.atlassian.user.impl.ldap.properties.LdapSearchProperties;
import org.apache.log4j.Logger;

import java.util.Properties;

public class LdapSearchPropertiesFactory
{
    protected final Logger log = Logger.getLogger(this.getClass());

    public LdapSearchProperties createInstance(Properties properties)
    {
        DefaultLdapSearchProperties result = new DefaultLdapSearchProperties();
        result.setBaseGroupNamespace(properties.getProperty(Configuration.BASE_GROUP_NAMESPACE));
        result.setBaseUserNamespace(properties.getProperty(Configuration.BASE_USER_NAMESPACE));
        result.setEmailAttribute(properties.getProperty(Configuration.EMAIL_ATTRIBUTE));
        result.setFirstnameAttribute(properties.getProperty(Configuration.FIRSTNAME_ATTRIBUTE));
        result.setGroupFilter(properties.getProperty(Configuration.GROUP_SEARCH_FILTER));
        result.setGroupnameAttribute(properties.getProperty(Configuration.GROUPNAME_ATTRIBUTE));
        String groupSearchScopeAllDepths = properties.getProperty(Configuration.GROUP_SEARCH_ALL_DEPTHS);
        result.setGroupSearchScopeAllDepths(Boolean.valueOf(groupSearchScopeAllDepths).booleanValue());
        result.setSurnameAttribute(properties.getProperty(Configuration.SURNAME_ATTRIBUTE));
        String timeLimitMillis = properties.getProperty(Configuration.TIME_TO_LIVE);
        try
        {
            result.setTimeLimitMillis(Integer.parseInt(timeLimitMillis));
        }
        catch (NumberFormatException e)
        {
            log.warn("Error parsing LDAP time limit (in millis) in configuration file, using default value", e);
        }
        result.setUserFilter(properties.getProperty(Configuration.USER_SEARCH_FILTER));
        result.setUsernameAttribute(properties.getProperty(Configuration.USERNAME_ATTRIBUTE));
        String userSearchScopeAllDepths = properties.getProperty(Configuration.USER_SEARCH_ALL_DEPTHS);
        result.setUserSearchScopeAllDepths(Boolean.valueOf(userSearchScopeAllDepths).booleanValue());

        return result;
    }
}
