package com.atlassian.user.impl.memory;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.impl.ReadOnlyUserManager;
import com.atlassian.user.impl.memory.provider.MemoryProvider;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.security.password.PasswordEncryptor;

public class MemoryUserManagerReadOnly extends ReadOnlyUserManager implements UserManager
{
    private final RepositoryIdentifier repository;
    private final MemoryProvider provider;
    private final PasswordEncryptor encryptor;

    public MemoryUserManagerReadOnly(RepositoryIdentifier repository, MemoryProvider provider, PasswordEncryptor passwordEncryptor)
    {
        this.repository = repository;
        this.provider = provider;
        this.encryptor = passwordEncryptor;
    }

    /**
     * @return a {@link PasswordEncryptor} which handles the encrypytion of passwords for users managed by this object.
     */
    public PasswordEncryptor getPasswordEncryptor(User user) throws EntityException
    {
        if (getUser(user.getName()) != null)
            return encryptor;

        return null;
    }

    public Pager getUsers()
     {
         return provider.getUsers();
     }

     public Pager getUserNames() throws EntityException
     {
         return provider.getUserNames();
     }

     public User getUser(String username)
     {
         return provider.getUser(username);
     }

    /**
     * @return the {@link RepositoryIdentifier} which is managed by this instance.
     */
    public RepositoryIdentifier getIdentifier()
    {
        return repository;
    }

    /**
     * @return the {@link RepositoryIdentifier} in which the entity is stored, otherwise null.
     */
    public RepositoryIdentifier getRepository(Entity entity) throws EntityException
    {
        if (getUser(entity.getName()) != null)
            return repository;

        return null;
    }
}
