package com.atlassian.user.impl.osuser;

import com.opensymphony.user.provider.AccessProvider;
import com.opensymphony.user.provider.CredentialsProvider;
import com.opensymphony.user.provider.ProfileProvider;
import com.opensymphony.user.UserManager;

import java.io.Serializable;

/**
 * UserManager.OSUAccessor is a gateway that can be passed from the UserManager
 * to any other object that allows priveleged callbacks.
 */
public class DefaultOSUAccessor implements Serializable, OSUAccessor
{
    private AccessProvider accessProvider;
    private CredentialsProvider credentialsProvider;
    private ProfileProvider profileProvider;

    public DefaultOSUAccessor(){}

    public DefaultOSUAccessor(AccessProvider accessProvider, CredentialsProvider credentialsProvider, ProfileProvider profileProvider)
    {
        this.accessProvider = accessProvider;
        this.credentialsProvider = credentialsProvider;
        this.profileProvider = profileProvider;
    }

    public UserManager getUserManager()
    {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not make use of the osuser UserManager singleton. " +
                "Use IoC instead");
    }

    /**
     * Return appropriate AccessProvider for entity.
     */
    public AccessProvider getAccessProvider(String name)
    {
        if (accessProvider.handles(name))
            return accessProvider;

        return null;
    }

    /**
     * Return appropriate CredentialsProvider for entity.
     */
    public CredentialsProvider getCredentialsProvider(String name)
    {
        if (credentialsProvider.handles(name))
            return credentialsProvider;

        return null;
    }

    /**
     * Return appropriate ProfileProvider for entity.
     */
    public ProfileProvider getProfileProvider(String name)
    {
        if (profileProvider.handles(name))
            return profileProvider;

        return null;
    }

    public AccessProvider getAccessProvider()
    {
        return accessProvider;
    }

    public CredentialsProvider getCredentialsProvider()
    {
        return credentialsProvider;
    }

    public ProfileProvider getProfileProvider()
    {
        return profileProvider;
    }

    public void setAccessProvider(AccessProvider accessProvider)
    {
        this.accessProvider = accessProvider;
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider)
    {
        this.credentialsProvider = credentialsProvider;
    }

    public void setProfileProvider(ProfileProvider profileProvider)
    {
        this.profileProvider = profileProvider;
    }
}
