package com.atlassian.user.impl.osuser;

/**
 * An Atlassian {@link OSUUserManager} needs to be able
 * to reference an DelegationAccessor whenever it constructs a {@link com.opensymphony.user.User} and uses this interface to do it.
 *
 * The {@link com.opensymphony.user.ManagerAccessor} lets the {@link com.opensymphony.user.UserManager}
 * locate appropriate providers to use when reconstructing an entity - which is to say for each
 * getUser('fred') call a new {@link com.opensymphony.user.User} object is constructed,
 * with the capability to reference a {@link CredentialsProvider}.
 *
 * The {@link com.opensymphony.user.ManagerAccessor} therefore offers accessors to providers for the {@link com.opensymphony.user.UserManager},
 * as a helper access object.
 *
 * As provider information is served out by the accessor for osuser needs, Atlassian User reuses this interface as a way to
 * find its provider information for the entity managers - {@link OSUUserManager} and {@link OSUGroupManager}.
 *
 * One important thing to note is that the Atlassian User OSUAccessor extension has to operate in a delegated environment,
 * where a number of OSUAccessor objects might
 * exist, so it specifies a one-to-one relationship between the entity managers ({@link OSUUserManager}, {@link OSUGroupManager}) and
 * the accessor. The original OSUUser UserManager singleton maintained static lists of all providers and used the ManagerAccessor as a means
 * of letting each constructed {@link com.opensymphony.user.Entity} find the appropriate one.
 */

import com.opensymphony.user.provider.AccessProvider;
import com.opensymphony.user.provider.CredentialsProvider;
import com.opensymphony.user.provider.ProfileProvider;
import com.opensymphony.user.provider.UserProvider;

import java.util.Collection;
import java.util.List;

public interface OSUAccessor extends com.opensymphony.user.ManagerAccessor
{
    AccessProvider getAccessProvider();

    CredentialsProvider getCredentialsProvider();

    ProfileProvider getProfileProvider();

    void setCredentialsProvider(CredentialsProvider credentialsProvider);

    void setAccessProvider(AccessProvider accessProvider);

    void setProfileProvider(ProfileProvider profileProvider);
}
