package com.atlassian.user.search;

import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.page.PagerFactory;

import java.util.Iterator;

public class DefaultSearchResult extends AbstractSearchResult
{
    public DefaultSearchResult(){}

    public DefaultSearchResult(Pager result, String repositoryKey)
    {
        this();
        addToResults(repositoryKey, result);
    }

    public Pager pager()
    {
        Pager result = null;

        Iterator iter = repositoriesToResults.values().iterator();

        while (iter.hasNext())
        {
            if (result == null)
                result = (Pager) iter.next();
            else
                result = PagerFactory.getPager(result, (Pager) iter.next());
        }

        return result;
    }

}
