package com.atlassian.user.search;

import com.atlassian.user.Entity;

import java.util.Comparator;
import java.text.Collator;

/**
 * Instances of this class are <strong>NOT</strong> safe for concurrent use by multiple threads.
 * Ensure that only one thread has access to a particular instance at a time.
 * This is necessary as the underlying {@link Collator} instance is not threadsafe.
 */
public class EntityNameAlphaComparator implements Comparator
{
    private final Collator collator;

    public EntityNameAlphaComparator(Collator collator)
    {
        this.collator = collator;
    }

    public EntityNameAlphaComparator()
    {
        collator = Collator.getInstance();
    }

    public int compare(Object o1, Object o2)
    {
        return collator.compare(((Entity)o1).getName(), ((Entity)o2).getName());
    }
}
