package com.atlassian.user.search;

import com.atlassian.user.search.page.Pager;

import java.util.Set;

public interface SearchResult
{
    /**
     * @return returns a {@link Pager} representing all results from the search.
     */
    Pager pager();

    /**
     * @return a {@link Pager} holding results for the {@link com.atlassian.user.repository.RepositoryIdentifier} specified
     * by {@link com.atlassian.user.repository.RepositoryIdentifier#getKey()}}
     */
    Pager pager(String repoKey);

    /**
     * @return a list of {@link String} objects indicating the corresponding {@link com.atlassian.user.repository.RepositoryIdentifier}
     * via its {@link com.atlassian.user.repository.RepositoryIdentifier#getKey()} with results in this object.
     */
    Set repositoryKeyset();
}
