package com.atlassian.user.search.page;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PagerFactory
{
    /**
     * @param pagerOne
     * @param pagerTwo
     * @return a MergedPager if and only if both pagers passed in are not null
     */
    public static Pager getPager(Pager pagerOne, Pager pagerTwo)
    {
        if (pagerOne != null && pagerTwo != null)
        {
            List pagers = new ArrayList();
            pagers.add(pagerOne);
            pagers.add(pagerTwo);
            return getPager(pagers);
        }
        else if (pagerOne != null)
            return pagerOne;
        else if (pagerTwo != null)
            return pagerTwo;
        else
            return new DefaultPager();
    }

    public static Pager getPager(List pagers)
    {
        for (Iterator it = pagers.iterator(); it.hasNext();)
        {
            Pager pager = (Pager) it.next();
            if (pager == null || pager.isEmpty())
                it.remove();
        }

        if (pagers.size() == 0)
            return new DefaultPager();

        if (pagers.size() == 1)
            return (Pager) pagers.get(0);

        return new MergedListPager(pagers);
    }
}
