package com.atlassian.user.search.query;

/**
 * Here the term should correspond to a user.
 * This will be parsed into a query returning all groups for the user.
 */
public class GroupsOfUserTwoTermQuery extends TwoTermBooleanQuery implements MembershipQuery
{
    public GroupsOfUserTwoTermQuery(UserNameTermQuery userNameQuery)
    {
        super(userNameQuery, new GroupNameTermQuery(TermQuery.WILDCARD), true);
    }

    public GroupsOfUserTwoTermQuery(GroupNameTermQuery groupNameQuery)
    {
        super(new UserNameTermQuery(TermQuery.WILDCARD), groupNameQuery, true);
    }

    public GroupsOfUserTwoTermQuery(UserNameTermQuery userNameQuery, GroupNameTermQuery groupNameQuery)
    {
        super(userNameQuery, groupNameQuery, true);
    }

    public UserNameTermQuery getUserNameTermQuery()
    {
        return (UserNameTermQuery) getFirstQuery();
    }

    public GroupNameTermQuery getGroupNameTermQuery()
    {
        return (GroupNameTermQuery) getSecondQuery();
    }
}
