package com.atlassian.user.search.query;

public class TwoTermBooleanQuery extends AbstractBooleanQuery
{
    private Query query1;
    private Query query2;

    /**
     * Defaults anding to true
     */ 
    public TwoTermBooleanQuery(Query query1, Query query2)
    {
        super(true);
        this.query1 = query1;
        this.query2 = query2;

        queries.add(query1);
        queries.add(query2);
    }

    public TwoTermBooleanQuery(Query query1, Query query2, String anding)
    {
        super(anding);
        this.query1 = query1;
        this.query2 = query2;

        queries.add(query1);
        queries.add(query2);
    }


    public TwoTermBooleanQuery(Query query1, Query query2, boolean anding)
    {
        super(anding);
        this.query1 = query1;
        this.query2 = query2;
        this.anding = anding;

        queries.add(query1);
        queries.add(query2);
    }

    public Query getFirstQuery()
    {
        return query1;
    }

    public Query getSecondQuery()
    {
        return query2;
    }
}
