package com.atlassian.user.util;

import java.util.Enumeration;
import java.util.Iterator;

/**
 * Wraps an enumeration with an iterator interface
 */
public class EnumerationAdaptor implements Iterator
{
    private final Enumeration enumeration;

    public EnumerationAdaptor(Enumeration enumeration)
    {
        this.enumeration = enumeration;
    }

    public void remove()
    {
        throw new UnsupportedOperationException();
    }

    public boolean hasNext()
    {
        return enumeration.hasMoreElements();
    }

    public Object next()
    {
        return enumeration.nextElement();
    }
}
