/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.configuration;

import com.atlassian.user.GroupManager;
import com.atlassian.user.UserManager;
import com.atlassian.user.configuration.DelegationAccessor;
import com.atlassian.user.configuration.RepositoryAccessor;
import com.atlassian.user.impl.delegation.DelegatingListGroupManager;
import com.atlassian.user.impl.delegation.DelegatingListUserManager;
import com.atlassian.user.impl.delegation.properties.DelegatingPropertySetFactory;
import com.atlassian.user.impl.delegation.search.query.DelegatingEntityQueryParser;
import com.atlassian.user.impl.delegation.security.authentication.DelegatingAuthenticator;
import com.atlassian.user.properties.PropertySetFactory;
import com.atlassian.user.repository.DefaultRepositoryIdentifier;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.search.query.EntityQueryParser;
import com.atlassian.user.security.authentication.Authenticator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DefaultDelegationAccessor
implements DelegationAccessor {
    private Map repositoryAccessors = new HashMap();
    private List delegationOrder = new ArrayList();
    private DelegatingAuthenticator delegatingAuthenticator;
    private DelegatingListGroupManager delegatingGroupManager;
    private DelegatingPropertySetFactory delegatingPropertySetFactory;
    private DelegatingListUserManager delegatingUserManager;
    private DelegatingEntityQueryParser delegatingEntityQueryParser;
    private List authenticators = new ArrayList();
    private List userManagers = new ArrayList();
    private List groupManagers = new ArrayList();
    private List propertySetFactories = new ArrayList();
    private List entityQueryParsers = new ArrayList();

    public DefaultDelegationAccessor() {
    }

    public DefaultDelegationAccessor(List repositoryAccessors) {
        Iterator iterator = repositoryAccessors.iterator();
        while (iterator.hasNext()) {
            RepositoryAccessor accessor = (RepositoryAccessor)iterator.next();
            this.addRepositoryAccessor(accessor);
        }
    }

    public RepositoryIdentifier getIdentifier() {
        return new DefaultRepositoryIdentifier("delegatingRepository", "Delegating Repository");
    }

    public UserManager getUserManager() {
        return this.delegatingUserManager;
    }

    public GroupManager getGroupManager() {
        return this.delegatingGroupManager;
    }

    public PropertySetFactory getPropertySetFactory() {
        return this.delegatingPropertySetFactory;
    }

    public Authenticator getAuthenticator() {
        return this.delegatingAuthenticator;
    }

    public EntityQueryParser getEntityQueryParser() {
        return this.delegatingEntityQueryParser;
    }

    public RepositoryAccessor getRepositoryAccessor(String key) {
        Iterator it = this.repositoryAccessors.keySet().iterator();
        while (it.hasNext()) {
            RepositoryIdentifier identifier = (RepositoryIdentifier)it.next();
            if (!identifier.getKey().equals(key)) continue;
            return (RepositoryAccessor)this.repositoryAccessors.get(identifier);
        }
        return null;
    }

    public List getRepositoryAccessors() {
        LinkedList result = new LinkedList();
        Iterator it = this.delegationOrder.iterator();
        while (it.hasNext()) {
            RepositoryIdentifier identifier = (RepositoryIdentifier)it.next();
            result.add(this.repositoryAccessors.get(identifier));
        }
        return result;
    }

    public void addRepositoryAccessor(RepositoryAccessor accessor) {
        this.repositoryAccessors.put(accessor.getIdentifier(), accessor);
        this.delegationOrder.add(accessor.getIdentifier());
        if (accessor.getAuthenticator() != null) {
            this.authenticators.add(accessor.getAuthenticator());
        }
        if (accessor.getUserManager() != null) {
            this.userManagers.add(accessor.getUserManager());
        }
        if (accessor.getGroupManager() != null) {
            this.groupManagers.add(accessor.getGroupManager());
        }
        if (accessor.getPropertySetFactory() != null) {
            this.propertySetFactories.add(accessor.getPropertySetFactory());
        }
        if (accessor.getEntityQueryParser() != null) {
            this.entityQueryParsers.add(accessor.getEntityQueryParser());
        }
        this.delegatingUserManager = new DelegatingListUserManager(this.userManagers);
        this.delegatingAuthenticator = new DelegatingAuthenticator(this.delegatingUserManager, this.authenticators);
        this.delegatingPropertySetFactory = new DelegatingPropertySetFactory(this.propertySetFactories);
        this.delegatingGroupManager = new DelegatingListGroupManager(this.groupManagers);
        this.delegatingEntityQueryParser = new DelegatingEntityQueryParser(this.entityQueryParsers);
    }
}

