/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.osuser;

import com.atlassian.user.User;
import com.atlassian.user.impl.osuser.OSUEntity;
import com.opensymphony.user.Entity;
import com.opensymphony.user.ImmutableException;
import org.apache.log4j.Category;

public class OSUUser
extends OSUEntity
implements User {
    private static final Category log = Category.getInstance((Class)OSUUser.class);
    protected com.opensymphony.user.User osuser;

    public OSUUser(com.opensymphony.user.User osuser) {
        super((Entity)osuser);
        this.osuser = osuser;
    }

    public String getFullName() {
        try {
            return this.osuser.getFullName();
        }
        catch (Exception e) {
            log.error((Object)("Error getting full name for user with name: " + this.getName()), (Throwable)e);
            return null;
        }
    }

    public String getEmail() {
        try {
            return this.osuser.getEmail();
        }
        catch (Exception e) {
            log.error((Object)("Error getting email for user with name: " + this.getName()), (Throwable)e);
            return null;
        }
    }

    public String toString() {
        StringBuffer sf = new StringBuffer();
        sf = sf.append("user: [" + this.getName() + "]\n");
        sf = sf.append("email: [" + this.getEmail() + "]\n");
        sf = sf.append("fullName: [" + this.getFullName() + "]\n");
        return sf.toString();
    }

    public void setEmail(String email) {
        this.osuser.setEmail(email);
    }

    public void setFullName(String fullName) {
        this.osuser.setFullName(fullName);
    }

    public void setPassword(String password) {
        try {
            this.osuser.setPassword(password);
        }
        catch (ImmutableException e) {
            log.error((Object)"Could not alter password: ", (Throwable)e);
            throw new IllegalStateException("Could not alter password: " + (Object)((Object)e));
        }
    }
}

