/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.search.query;

import com.atlassian.user.search.query.BooleanQuery;
import com.atlassian.user.search.query.EntityQueryException;
import com.atlassian.user.search.query.EntityQueryParser;
import com.atlassian.user.search.query.GroupQuery;
import com.atlassian.user.search.query.MembershipQuery;
import com.atlassian.user.search.query.Query;
import com.atlassian.user.search.query.TermQuery;
import com.atlassian.user.search.query.UserQuery;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractEntityQueryParser
implements EntityQueryParser {
    protected void validateQuery(Query query) throws EntityQueryException {
        if (query instanceof MembershipQuery) {
            throw new IllegalArgumentException("Membership queries are illegal until we verify they can be performed on all LDAP system (i.e. the membership attribute must support substring matching");
        }
        if (query == null) {
            throw new IllegalArgumentException("Null arg.");
        }
        if (!(query instanceof BooleanQuery)) {
            return;
        }
        this.validateBooleanToQueryType((BooleanQuery)query, null);
    }

    protected void validateBooleanToQueryType(BooleanQuery query, String queryClassName) throws EntityQueryException {
        List queries = query.getQueries();
        Iterator queryIter = queries.iterator();
        while (queryIter.hasNext()) {
            Query foundQuery = (Query)queryIter.next();
            if (foundQuery instanceof BooleanQuery) {
                this.validateBooleanToQueryType((BooleanQuery)foundQuery, queryClassName);
                return;
            }
            if (queryClassName != null) continue;
            queryClassName = this.matchQueryToQueryType(foundQuery);
        }
    }

    protected String matchQueryToQueryType(Query query1) {
        String queryClassName = null;
        if (query1 instanceof UserQuery) {
            queryClassName = UserQuery.class.getName();
        } else if (query1 instanceof GroupQuery) {
            queryClassName = GroupQuery.class.getName();
        } else if (query1 instanceof MembershipQuery) {
            queryClassName = MembershipQuery.class.getName();
        }
        return queryClassName;
    }

    protected Query identifyDefiningQuery(BooleanQuery q) {
        if (q instanceof MembershipQuery) {
            return q;
        }
        Iterator iter = q.getQueries().iterator();
        TermQuery foundQuery = null;
        while (iter.hasNext()) {
            Query query = (Query)iter.next();
            if (query instanceof TermQuery) {
                foundQuery = (TermQuery)query;
                break;
            }
            if (!(query instanceof BooleanQuery)) continue;
            return this.identifyDefiningQuery((BooleanQuery)query);
        }
        return foundQuery;
    }
}

