/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.android;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import com.dropbox.core.DbxHost;
import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.TokenAccessType;
import com.dropbox.core.android.AuthActivity;
import com.dropbox.core.oauth.DbxCredential;
import java.util.Arrays;

public class Auth {
    public static void startOAuth2Authentication(Context context, String appKey) {
        Auth.startOAuth2Authentication(context, appKey, null, null, null);
    }

    public static void startOAuth2Authentication(Context context, String appKey, String desiredUid, String[] alreadyAuthedUids, String sessionId) {
        Auth.startOAuth2Authentication(context, appKey, desiredUid, alreadyAuthedUids, sessionId, "www.dropbox.com");
    }

    public static void startOAuth2PKCE(Context context, String appKey, DbxRequestConfig requestConfig) {
        Auth.startOAuth2PKCE(context, appKey, requestConfig, null, null);
    }

    public static void startOAuth2PKCE(Context context, String appKey, DbxRequestConfig requestConfig, String scope) {
        Auth.startOAuth2PKCE(context, appKey, requestConfig, null, scope);
    }

    public static void startOAuth2PKCE(Context context, String appKey, DbxRequestConfig requestConfig, DbxHost host) {
        if (requestConfig == null) {
            throw new IllegalArgumentException("Invalid Dbx requestConfig for PKCE flow.");
        }
        Auth.startOAuth2Authentication(context, appKey, null, null, null, null, TokenAccessType.OFFLINE, requestConfig, host);
    }

    public static void startOAuth2PKCE(Context context, String appKey, DbxRequestConfig requestConfig, DbxHost host, String scope) {
        if (requestConfig == null) {
            throw new IllegalArgumentException("Invalid Dbx requestConfig for PKCE flow.");
        }
        Auth.startOAuth2Authentication(context, appKey, null, null, null, null, TokenAccessType.OFFLINE, requestConfig, host, scope);
    }

    public static void startOAuth2Authentication(Context context, String appKey, String desiredUid, String[] alreadyAuthedUids, String sessionId, String webHost) {
        Auth.startOAuth2Authentication(context, appKey, desiredUid, alreadyAuthedUids, sessionId, webHost, null, null, null);
    }

    private static void startOAuth2Authentication(Context context, String appKey, String desiredUid, String[] alreadyAuthedUids, String sessionId, String webHost, TokenAccessType tokenAccessType, DbxRequestConfig requestConfig, DbxHost host) {
        Auth.startOAuth2Authentication(context, appKey, desiredUid, alreadyAuthedUids, sessionId, webHost, tokenAccessType, requestConfig, host, null);
    }

    private static void startOAuth2Authentication(Context context, String appKey, String desiredUid, String[] alreadyAuthedUids, String sessionId, String webHost, TokenAccessType tokenAccessType, DbxRequestConfig requestConfig, DbxHost host, String scope) {
        if (!AuthActivity.checkAppBeforeAuth(context, appKey, true)) {
            return;
        }
        if (alreadyAuthedUids != null && Arrays.asList(alreadyAuthedUids).contains(desiredUid)) {
            throw new IllegalArgumentException("desiredUid cannot be present in alreadyAuthedUids");
        }
        String apiType = "1";
        Intent intent = AuthActivity.makeIntent(context, appKey, desiredUid, alreadyAuthedUids, sessionId, webHost, apiType, tokenAccessType, requestConfig, host, scope);
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        context.startActivity(intent);
    }

    public static String getOAuth2Token() {
        DbxCredential credential = Auth.getDbxCredential();
        if (credential == null) {
            return null;
        }
        return credential.getAccessToken();
    }

    public static String getUid() {
        if (Auth.getDbxCredential() == null) {
            return null;
        }
        Intent data = AuthActivity.result;
        return data.getStringExtra("UID");
    }

    public static DbxCredential getDbxCredential() {
        Intent data = AuthActivity.result;
        if (data == null) {
            return null;
        }
        String token = data.getStringExtra("ACCESS_TOKEN");
        String secret = data.getStringExtra("ACCESS_SECRET");
        String uid = data.getStringExtra("UID");
        if (token == null || "".equals(token) || secret == null || "".equals(secret) || uid == null || "".equals(uid)) {
            return null;
        }
        String appKey = data.getStringExtra("CONSUMER_KEY");
        String refreshToken = data.getStringExtra("REFRESH_TOKEN");
        long expiresAt = data.getLongExtra("EXPIRES_AT", -1L);
        Long nullableExpiresAt = expiresAt >= 0L ? Long.valueOf(expiresAt) : null;
        return new DbxCredential(secret, nullableExpiresAt, refreshToken, appKey);
    }

    public static String getScope() {
        Intent data = AuthActivity.result;
        if (data == null) {
            return null;
        }
        return data.getStringExtra("SCOPE");
    }
}

