/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.util.LangUtil;
import com.dropbox.core.v2.team.LegalHoldStatus;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;

public class LegalHoldPolicy {
    protected final String id;
    protected final String name;
    protected final String description;
    protected final Date activationTime;
    protected final List<String> members;
    protected final LegalHoldStatus status;
    protected final Date startDate;
    protected final Date endDate;

    public LegalHoldPolicy(String id, String name, List<String> members, LegalHoldStatus status, Date startDate, String description, Date activationTime, Date endDate) {
        if (id == null) {
            throw new IllegalArgumentException("Required value for 'id' is null");
        }
        if (!Pattern.matches("^pid_dbhid:.+", id)) {
            throw new IllegalArgumentException("String 'id' does not match pattern");
        }
        this.id = id;
        if (name == null) {
            throw new IllegalArgumentException("Required value for 'name' is null");
        }
        if (name.length() > 140) {
            throw new IllegalArgumentException("String 'name' is longer than 140");
        }
        this.name = name;
        if (description != null && description.length() > 501) {
            throw new IllegalArgumentException("String 'description' is longer than 501");
        }
        this.description = description;
        this.activationTime = LangUtil.truncateMillis(activationTime);
        if (members == null) {
            throw new IllegalArgumentException("Required value for 'members' is null");
        }
        for (String x : members) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list 'members' is null");
        }
        this.members = members;
        if (status == null) {
            throw new IllegalArgumentException("Required value for 'status' is null");
        }
        this.status = status;
        if (startDate == null) {
            throw new IllegalArgumentException("Required value for 'startDate' is null");
        }
        this.startDate = LangUtil.truncateMillis(startDate);
        this.endDate = LangUtil.truncateMillis(endDate);
    }

    public LegalHoldPolicy(String id, String name, List<String> members, LegalHoldStatus status, Date startDate) {
        this(id, name, members, status, startDate, null, null, null);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getMembers() {
        return this.members;
    }

    public LegalHoldStatus getStatus() {
        return this.status;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getActivationTime() {
        return this.activationTime;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public static Builder newBuilder(String id, String name, List<String> members, LegalHoldStatus status, Date startDate) {
        return new Builder(id, name, members, status, startDate);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.id, this.name, this.description, this.activationTime, this.members, this.status, this.startDate, this.endDate});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            LegalHoldPolicy other = (LegalHoldPolicy)obj;
            return !(this.id != other.id && !this.id.equals(other.id) || this.name != other.name && !this.name.equals(other.name) || this.members != other.members && !this.members.equals(other.members) || this.status != other.status && !this.status.equals((Object)other.status) || this.startDate != other.startDate && !this.startDate.equals(other.startDate) || this.description != other.description && (this.description == null || !this.description.equals(other.description)) || this.activationTime != other.activationTime && (this.activationTime == null || !this.activationTime.equals(other.activationTime)) || this.endDate != other.endDate && (this.endDate == null || !this.endDate.equals(other.endDate)));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<LegalHoldPolicy> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(LegalHoldPolicy value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("id");
            StoneSerializers.string().serialize(value.id, g);
            g.writeFieldName("name");
            StoneSerializers.string().serialize(value.name, g);
            g.writeFieldName("members");
            StoneSerializers.list(StoneSerializers.string()).serialize(value.members, g);
            g.writeFieldName("status");
            LegalHoldStatus.Serializer.INSTANCE.serialize(value.status, g);
            g.writeFieldName("start_date");
            StoneSerializers.timestamp().serialize(value.startDate, g);
            if (value.description != null) {
                g.writeFieldName("description");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.description, g);
            }
            if (value.activationTime != null) {
                g.writeFieldName("activation_time");
                StoneSerializers.nullable(StoneSerializers.timestamp()).serialize(value.activationTime, g);
            }
            if (value.endDate != null) {
                g.writeFieldName("end_date");
                StoneSerializers.nullable(StoneSerializers.timestamp()).serialize(value.endDate, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public LegalHoldPolicy deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Date f_endDate;
            Date f_activationTime;
            String f_description;
            Date f_startDate;
            LegalHoldStatus f_status;
            List<String> f_members;
            String f_name;
            String f_id;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_id = null;
                f_name = null;
                f_members = null;
                f_status = null;
                f_startDate = null;
                f_description = null;
                f_activationTime = null;
                f_endDate = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("id".equals(field)) {
                        f_id = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("name".equals(field)) {
                        f_name = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("members".equals(field)) {
                        f_members = StoneSerializers.list(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("status".equals(field)) {
                        f_status = LegalHoldStatus.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("start_date".equals(field)) {
                        f_startDate = StoneSerializers.timestamp().deserialize(p);
                        continue;
                    }
                    if ("description".equals(field)) {
                        f_description = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("activation_time".equals(field)) {
                        f_activationTime = StoneSerializers.nullable(StoneSerializers.timestamp()).deserialize(p);
                        continue;
                    }
                    if ("end_date".equals(field)) {
                        f_endDate = StoneSerializers.nullable(StoneSerializers.timestamp()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_id == null) {
                    throw new JsonParseException(p, "Required field \"id\" missing.");
                }
                if (f_name == null) {
                    throw new JsonParseException(p, "Required field \"name\" missing.");
                }
                if (f_members == null) {
                    throw new JsonParseException(p, "Required field \"members\" missing.");
                }
                if (f_status == null) {
                    throw new JsonParseException(p, "Required field \"status\" missing.");
                }
                if (f_startDate == null) {
                    throw new JsonParseException(p, "Required field \"start_date\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            LegalHoldPolicy value = new LegalHoldPolicy(f_id, f_name, f_members, f_status, f_startDate, f_description, f_activationTime, f_endDate);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final String id;
        protected final String name;
        protected final List<String> members;
        protected final LegalHoldStatus status;
        protected final Date startDate;
        protected String description;
        protected Date activationTime;
        protected Date endDate;

        protected Builder(String id, String name, List<String> members, LegalHoldStatus status, Date startDate) {
            if (id == null) {
                throw new IllegalArgumentException("Required value for 'id' is null");
            }
            if (!Pattern.matches("^pid_dbhid:.+", id)) {
                throw new IllegalArgumentException("String 'id' does not match pattern");
            }
            this.id = id;
            if (name == null) {
                throw new IllegalArgumentException("Required value for 'name' is null");
            }
            if (name.length() > 140) {
                throw new IllegalArgumentException("String 'name' is longer than 140");
            }
            this.name = name;
            if (members == null) {
                throw new IllegalArgumentException("Required value for 'members' is null");
            }
            for (String x : members) {
                if (x != null) continue;
                throw new IllegalArgumentException("An item in list 'members' is null");
            }
            this.members = members;
            if (status == null) {
                throw new IllegalArgumentException("Required value for 'status' is null");
            }
            this.status = status;
            if (startDate == null) {
                throw new IllegalArgumentException("Required value for 'startDate' is null");
            }
            this.startDate = LangUtil.truncateMillis(startDate);
            this.description = null;
            this.activationTime = null;
            this.endDate = null;
        }

        public Builder withDescription(String description) {
            if (description != null && description.length() > 501) {
                throw new IllegalArgumentException("String 'description' is longer than 501");
            }
            this.description = description;
            return this;
        }

        public Builder withActivationTime(Date activationTime) {
            this.activationTime = LangUtil.truncateMillis(activationTime);
            return this;
        }

        public Builder withEndDate(Date endDate) {
            this.endDate = LangUtil.truncateMillis(endDate);
            return this;
        }

        public LegalHoldPolicy build() {
            return new LegalHoldPolicy(this.id, this.name, this.members, this.status, this.startDate, this.description, this.activationTime, this.endDate);
        }
    }
}

