package com.vaadin.copilot.javarewriter.custom;

import java.util.Optional;

import com.vaadin.copilot.javarewriter.JavaComponent;

public class CustomComponentHandler {
    private CustomComponentHandler() {
    }

    /**
     * Finds the relevant CustomComponentHandle of the given JavaComponent
     *
     * @param javaComponent
     *            Java component for creating statements.
     * @return Returns the custom component handle if present, returns empty
     *         otherwise.
     */
    public static Optional<CustomComponentHandle> get(JavaComponent javaComponent) {
        if ("Crud".equals(javaComponent.tag())) {
            return Optional.of(new CrudComponentHandle());
        } else if ("Details".equals(javaComponent.tag())) {
            return Optional.of(new DetailsComponentHandle());
        } else if ("Dashboard".equals(javaComponent.tag()) || "DashboardSection".equals(javaComponent.tag())
                || "DashboardWidget".equals(javaComponent.tag())) {
            return Optional.of(new DashboardComponentHandle());
        }
        return Optional.empty();
    }
}
