/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteParameterData;
import com.vaadin.flow.router.RouteParameterFormatOption;
import com.vaadin.flow.router.RouteParameters;
import com.vaadin.flow.router.internal.ConfigureRoutes;
import com.vaadin.flow.router.internal.NavigationRouteTarget;
import com.vaadin.flow.router.internal.PathUtil;
import com.vaadin.flow.router.internal.RouteFormat;
import com.vaadin.flow.router.internal.RouteModel;
import com.vaadin.flow.router.internal.RouteTarget;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ConfiguredRoutes
implements Serializable {
    private final RouteModel routeModel;
    private final Map<String, RouteTarget> routeMap;
    private final Map<Class<? extends Component>, String> targetRouteMap;
    private final Map<Class<? extends Component>, RouteModel> targetRouteModelMap;
    private final Map<Class<? extends Exception>, Class<? extends Component>> exceptionTargetMap;

    public ConfiguredRoutes() {
        this.routeModel = RouteModel.create(false);
        this.routeMap = Collections.emptyMap();
        this.targetRouteMap = Collections.emptyMap();
        this.targetRouteModelMap = Collections.emptyMap();
        this.exceptionTargetMap = Collections.emptyMap();
    }

    public ConfiguredRoutes(ConfigureRoutes original) {
        HashMap<String, RouteTarget> originalRouteMap = new HashMap<String, RouteTarget>();
        HashMap<Class<? extends Component>, String> originalTargetRouteMap = new HashMap<Class<? extends Component>, String>();
        HashMap<Class<? extends Exception>, Class<? extends Component>> originalExceptionTargetMap = new HashMap<Class<? extends Exception>, Class<? extends Component>>();
        for (Map.Entry<String, RouteTarget> route : original.getRoutesMap().entrySet()) {
            originalRouteMap.put(route.getKey(), route.getValue());
        }
        originalTargetRouteMap.putAll(original.getTargetRoutes());
        originalExceptionTargetMap.putAll(original.getExceptionHandlers());
        Map<Class<? extends Component>, RouteModel> originalTargetRouteModelMap = original.copyTargetRouteModels(false);
        this.routeModel = RouteModel.copy(original.getRouteModel(), false);
        this.routeMap = originalRouteMap.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(originalRouteMap);
        this.targetRouteMap = originalTargetRouteMap.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(originalTargetRouteMap);
        this.targetRouteModelMap = originalTargetRouteModelMap.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(originalTargetRouteModelMap);
        this.exceptionTargetMap = originalExceptionTargetMap.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(originalExceptionTargetMap);
    }

    protected Map<String, RouteTarget> getRoutesMap() {
        return this.routeMap;
    }

    RouteModel getRouteModel() {
        return this.routeModel;
    }

    protected List<String> getRoutePaths(Class<? extends Component> routeTarget) {
        return this.getRoutesMap().entrySet().stream().filter(entry -> ((RouteTarget)entry.getValue()).containsTarget(routeTarget)).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public boolean hasRoute(String path) {
        return this.hasTemplate(path);
    }

    public boolean hasTemplate(String template) {
        return this.getRoutesMap().containsKey(template);
    }

    public boolean hasRoute(String path, List<String> segments) {
        return this.getNavigationRouteTarget(PathUtil.getPath(path, segments)).hasTarget();
    }

    public boolean hasRouteTarget(Class<? extends Component> target) {
        return this.getTargetRoutes().containsKey(target);
    }

    public NavigationRouteTarget getNavigationRouteTarget(String url) {
        return this.getRouteModel().getNavigationRouteTarget(url);
    }

    public RouteTarget getRouteTarget(Class<? extends Component> target, RouteParameters parameters) {
        return this.iterateTemplates(target, template -> {
            try {
                return this.getRouteModel().getRouteTarget((String)template, parameters);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        });
    }

    public Optional<Class<? extends Component>> getTarget(String url) {
        NavigationRouteTarget result = this.getNavigationRouteTarget(url);
        if (result.hasTarget()) {
            RouteTarget routeTarget = result.getRouteTarget();
            return Optional.ofNullable(routeTarget.getTarget());
        }
        return Optional.empty();
    }

    public Optional<Class<? extends Component>> getRoute(String url, List<String> segments) {
        return this.getTarget(PathUtil.getPath(url, segments));
    }

    public Set<String> getRoutes() {
        return Collections.unmodifiableSet(this.getRoutesMap().keySet());
    }

    public Map<Class<? extends Component>, String> getTargetRoutes() {
        return this.targetRouteMap;
    }

    Map<Class<? extends Component>, RouteModel> getTargetRouteModelMap() {
        return this.targetRouteModelMap;
    }

    protected final Map<Class<? extends Component>, RouteModel> copyTargetRouteModels(boolean mutable) {
        HashMap<Class<? extends Component>, RouteModel> copyMap = new HashMap<Class<? extends Component>, RouteModel>();
        this.getTargetRouteModelMap().entrySet().forEach(entry -> copyMap.put((Class)entry.getKey(), RouteModel.copy((RouteModel)entry.getValue(), mutable)));
        return copyMap;
    }

    public String getTargetRoute(Class<? extends Component> navigationTarget) {
        return this.getTemplate(navigationTarget);
    }

    public String getTemplate(Class<? extends Component> navigationTarget) {
        return this.getTargetRoutes().get(navigationTarget);
    }

    public String getTemplate(Class<? extends Component> navigationTarget, Set<RouteParameterFormatOption> format) {
        String template = this.getTemplate(navigationTarget);
        if (template == null) {
            return null;
        }
        return this.getRouteModel().formatTemplate(template, format);
    }

    public String getTargetUrl(Class<? extends Component> navigationTarget) {
        return this.iterateTemplates(navigationTarget, template -> {
            if (RouteFormat.hasRequiredParameter(template)) {
                return null;
            }
            if (RouteFormat.hasParameters(template)) {
                return this.getRouteModel().getUrl((String)template, RouteParameters.empty());
            }
            return template;
        });
    }

    public String getTargetUrl(Class<? extends Component> navigationTarget, RouteParameters parameters) {
        return this.iterateTemplates(navigationTarget, template -> {
            try {
                return this.getRouteModel().getUrl((String)template, parameters);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        });
    }

    public Class<? extends Component> getExceptionHandlerByClass(Class<?> exceptionClass) {
        return this.getExceptionHandlers().get(exceptionClass);
    }

    public Map<Class<? extends Exception>, Class<? extends Component>> getExceptionHandlers() {
        return this.exceptionTargetMap;
    }

    public Map<String, RouteParameterData> getParameters(String template) {
        return this.getRouteModel().getParameters(template);
    }

    protected RouteTarget getRouteTarget(String template) {
        return this.getRoutesMap().get(template);
    }

    private <T> T iterateTemplates(Class<? extends Component> navigationTarget, Function<String, T> templateOutput) {
        RouteModel model = this.getTargetRouteModelMap().get(navigationTarget);
        if (model == null) {
            return null;
        }
        for (String template : ConfiguredRoutes.getOrderedTemplates(navigationTarget, model)) {
            T result = templateOutput.apply(template);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static Collection<String> getOrderedTemplates(Class<? extends Component> navigationTarget, RouteModel model) {
        String route;
        Set<String> templates = model.getRoutes().keySet();
        if (templates.size() <= 1) {
            return templates;
        }
        if (navigationTarget.isAnnotationPresent(Route.class) && templates.contains(route = PathUtil.trimPath(navigationTarget.getAnnotation(Route.class).value()))) {
            ArrayList<String> reorder = new ArrayList<String>();
            templates.remove(route);
            reorder.add(route);
            reorder.addAll(templates);
            return reorder;
        }
        return templates;
    }
}

