/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.JsonUtils;
import com.vaadin.flow.server.frontend.BundleValidationUtil;
import com.vaadin.flow.server.frontend.JarContentsManager;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.ThemeUtils;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import com.vaadin.flow.theme.ThemeDefinition;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonType;
import elemental.json.JsonValue;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThemeValidationUtil {
    private static final Pattern THEME_PATH_PATTERN = Pattern.compile("themes\\/([\\s\\S]+?)\\/theme.json");
    private static final String FRONTEND_HASHES_KEY = "frontendHashes";

    public static boolean themeConfigurationChanged(Options options, JsonObject statsJson, FrontendDependenciesScanner frontendDependencies) {
        HashMap<String, JsonObject> themeJsonContents = new HashMap<String, JsonObject>();
        if (options.getJarFiles() != null) {
            options.getJarFiles().stream().filter(File::exists).filter(file -> !file.isDirectory()).forEach(jarFile -> ThemeValidationUtil.getPackagedThemeJsonContents(jarFile, themeJsonContents));
        }
        Optional<String> maybeThemeName = Optional.ofNullable(frontendDependencies.getThemeDefinition()).map(ThemeDefinition::getName).filter(name -> !name.isBlank());
        Optional projectThemeJson = maybeThemeName.flatMap(themeName -> ThemeUtils.getThemeJson(themeName, options.getFrontendDirectory()));
        String projectThemeName = maybeThemeName.orElse(null);
        JsonObject statsThemeJson = statsJson.getObject("themeJsonContents");
        if (statsThemeJson == null && (!themeJsonContents.isEmpty() || projectThemeJson.isPresent())) {
            ThemeValidationUtil.getLogger().info("Found newly added theme configurations in 'theme.json'.");
            return true;
        }
        if (projectThemeJson.isPresent()) {
            String key;
            if (statsThemeJson.hasKey(projectThemeName)) {
                key = projectThemeName;
            } else if (!options.isProductionMode() && statsThemeJson.hasKey("vaadin-dev-bundle")) {
                key = "vaadin-dev-bundle";
            } else if (options.isProductionMode() && statsThemeJson.hasKey("vaadin-prod-bundle")) {
                key = "vaadin-prod-bundle";
            } else {
                ThemeValidationUtil.getLogger().info("Found newly added configuration for project theme '{}' in 'theme.json'.", (Object)projectThemeName);
                return true;
            }
            ThemeValidationUtil.collectThemeJsonContentsInFrontend(options, themeJsonContents, key, (JsonObject)projectThemeJson.get());
        }
        for (Map.Entry<String, JsonObject> entry : themeJsonContents.entrySet()) {
            if (ThemeValidationUtil.hasNewAssetsOrImports(statsThemeJson, entry)) {
                ThemeValidationUtil.getLogger().info("Found new configuration for theme '{}' in 'theme.json'.", (Object)entry.getKey());
                return true;
            }
            if (!statsThemeJson.hasKey(entry.getKey())) continue;
            ArrayList<String> missedKeys = new ArrayList<String>();
            JsonObject content = Json.parse((String)statsThemeJson.getString(entry.getKey()));
            if (ThemeValidationUtil.objectIncludesEntry((JsonValue)content, (JsonValue)entry.getValue(), missedKeys)) continue;
            ThemeValidationUtil.getLogger().info("Custom theme '{}' has imports/assets removed or added in 'theme.json' not represented in the bundle ('stats.json').", (Object)entry.getKey());
            ThemeValidationUtil.logMissedEntries(missedKeys);
            return true;
        }
        return false;
    }

    public static boolean themeShadowDOMStylesheetsChanged(Options options, JsonObject statsJson, FrontendDependenciesScanner frontendDependencies) {
        File frontendDirectory = options.getFrontendDirectory();
        Set themeComponentsDirs = Optional.ofNullable(frontendDependencies.getThemeDefinition()).map(ThemeDefinition::getName).filter(name -> !name.isBlank()).map(themeName -> {
            HashMap themeJsonContents = new HashMap();
            ThemeUtils.getThemeJson(themeName, frontendDirectory).ifPresent(themeJson -> ThemeValidationUtil.collectThemeJsonContentsInFrontend(options, themeJsonContents, themeName, themeJson));
            return themeJsonContents.keySet().stream().map(name -> ThemeUtils.getThemeFolder(frontendDirectory, name)).map(dir -> new File((File)dir, "components")).filter(File::exists).map(File::toPath).collect(Collectors.toSet());
        }).orElse(null);
        if (themeComponentsDirs != null) {
            HashMap hashesWithNoComponentCssMatches = new HashMap();
            if (statsJson.hasKey(FRONTEND_HASHES_KEY)) {
                JsonObject json = statsJson.getObject(FRONTEND_HASHES_KEY);
                Stream.of(json.keys()).filter(path -> themeComponentsDirs.stream().anyMatch(dir -> frontendDirectory.toPath().resolve((String)path).startsWith((Path)dir))).forEach(key -> hashesWithNoComponentCssMatches.put(key, json.getString(key)));
            }
            ArrayList<String> themeComponentsCssFiles = new ArrayList<String>();
            for (Path dir : themeComponentsDirs) {
                FileUtils.listFiles((File)dir.toFile(), (String[])new String[]{"css"}, (boolean)true).stream().filter(themeFile -> ThemeValidationUtil.isFrontendResourceChangedOrMissingInBundle(hashesWithNoComponentCssMatches, frontendDirectory, themeFile)).map(f -> frontendDirectory.toPath().relativize(f.toPath()).toString().replaceAll("\\\\", "/")).collect(Collectors.toCollection(() -> themeComponentsCssFiles));
            }
            if (!themeComponentsCssFiles.isEmpty()) {
                BundleValidationUtil.logChangedFiles(themeComponentsCssFiles, "Detected new or changed theme components CSS files");
            }
            if (!hashesWithNoComponentCssMatches.isEmpty()) {
                BundleValidationUtil.logChangedFiles(new ArrayList<String>(hashesWithNoComponentCssMatches.keySet()), "Detected removed theme components CSS files");
            }
            return !themeComponentsCssFiles.isEmpty() || !hashesWithNoComponentCssMatches.isEmpty();
        }
        return false;
    }

    private static boolean hasNewAssetsOrImports(JsonObject contentsInStats, Map.Entry<String, JsonObject> themeContent) {
        JsonObject json = themeContent.getValue();
        boolean moreThanOneKey = json.keys().length > 1;
        boolean noParentEntry = json.keys().length == 1 && !json.hasKey("parent");
        return !contentsInStats.hasKey(themeContent.getKey()) && (moreThanOneKey || noParentEntry);
    }

    private static void collectThemeJsonContentsInFrontend(Options options, Map<String, JsonObject> themeJsonContents, String themeName, JsonObject themeJson) {
        Optional<String> parentThemeInFrontend = ThemeUtils.getParentThemeName(themeJson);
        if (parentThemeInFrontend.isPresent()) {
            String parentThemeName = parentThemeInFrontend.get();
            Optional<JsonObject> parentThemeJson = ThemeUtils.getThemeJson(parentThemeName, options.getFrontendDirectory());
            parentThemeJson.ifPresent(jsonObject -> ThemeValidationUtil.collectThemeJsonContentsInFrontend(options, themeJsonContents, parentThemeName, jsonObject));
        }
        themeJsonContents.put(themeName, themeJson);
    }

    static boolean objectIncludesEntry(JsonValue jsonFromBundle, JsonValue projectJson, Collection<String> missedKeys) {
        JsonType bundleJsonType = jsonFromBundle.getType();
        JsonType projectJsonObjectTypeType = projectJson.getType();
        assert (bundleJsonType.equals((Object)projectJsonObjectTypeType));
        if (bundleJsonType == JsonType.NULL) {
            return true;
        }
        if (bundleJsonType == JsonType.BOOLEAN) {
            return JsonUtils.booleanEqual(jsonFromBundle, projectJson);
        }
        if (bundleJsonType == JsonType.NUMBER) {
            return JsonUtils.numbersEqual(jsonFromBundle, projectJson);
        }
        if (bundleJsonType == JsonType.STRING) {
            return JsonUtils.stringEqual(jsonFromBundle, projectJson);
        }
        if (bundleJsonType == JsonType.ARRAY) {
            JsonArray jsonArrayFromBundle = (JsonArray)jsonFromBundle;
            JsonArray jsonArrayFromProject = (JsonArray)projectJson;
            return ThemeValidationUtil.compareArrays(missedKeys, jsonArrayFromBundle, jsonArrayFromProject);
        }
        if (bundleJsonType == JsonType.OBJECT) {
            JsonObject jsonObjectFromBundle = (JsonObject)jsonFromBundle;
            JsonObject projectJsonObject = (JsonObject)projectJson;
            return ThemeValidationUtil.compareObjects(missedKeys, jsonObjectFromBundle, projectJsonObject);
        }
        throw new IllegalArgumentException("Unsupported JsonType: " + bundleJsonType);
    }

    private static void logMissedEntries(List<String> missedKeys) {
        Collections.reverse(missedKeys);
        BundleValidationUtil.logChangedFiles(missedKeys, "Detected missed or added entries:");
    }

    private static void getPackagedThemeJsonContents(File jarFileToLookup, Map<String, JsonObject> packagedThemeHashes) {
        JarContentsManager jarContentsManager = new JarContentsManager();
        if (jarContentsManager.containsPath(jarFileToLookup, "META-INF/resources/themes/")) {
            List<String> themeJsons = jarContentsManager.findFiles(jarFileToLookup, "META-INF/resources/themes/", "theme.json");
            for (String themeJson : themeJsons) {
                byte[] byteContent = jarContentsManager.getFileContents(jarFileToLookup, themeJson);
                String content = IOUtils.toString((byte[])byteContent, (String)"UTF-8");
                content = content.replaceAll("\\r\\n", "\n");
                Matcher matcher = THEME_PATH_PATTERN.matcher(themeJson);
                if (!matcher.find()) {
                    throw new IllegalStateException("Packaged theme folders structure is incorrect, should have META-INF/resources/themes/[theme-name]/");
                }
                String themeName = matcher.group(1);
                JsonObject jsonContent = Json.parse((String)content);
                packagedThemeHashes.put(themeName, jsonContent);
            }
        }
    }

    private static boolean compareObjects(Collection<String> missedKeys, JsonObject jsonObjectFromBundle, JsonObject projectJsonObject) {
        boolean allEntriesFound = true;
        for (String projectEntryKey : projectJsonObject.keys()) {
            JsonValue projectEntry = projectJsonObject.get(projectEntryKey);
            if (projectEntry.getType() == JsonType.STRING && "parent".equals(projectEntryKey)) continue;
            boolean entryFound = false;
            for (String bundleEntryKey : jsonObjectFromBundle.keys()) {
                JsonValue bundleEntry = jsonObjectFromBundle.get(bundleEntryKey);
                if (bundleEntry.getType() != projectEntry.getType() || !ThemeValidationUtil.objectIncludesEntry(bundleEntry, projectEntry, missedKeys)) continue;
                entryFound = true;
                break;
            }
            if (!entryFound) {
                missedKeys.add(projectEntryKey);
            }
            allEntriesFound = allEntriesFound && entryFound;
        }
        return allEntriesFound;
    }

    private static boolean compareArrays(Collection<String> missedKeys, JsonArray jsonArrayFromBundle, JsonArray jsonArrayFromProject) {
        boolean allEntriesFound = ThemeValidationUtil.checkMissedKeys(missedKeys, jsonArrayFromBundle, jsonArrayFromProject);
        if (jsonArrayFromBundle.length() != jsonArrayFromProject.length()) {
            allEntriesFound = allEntriesFound && ThemeValidationUtil.checkMissedKeys(missedKeys, jsonArrayFromProject, jsonArrayFromBundle);
        }
        return allEntriesFound;
    }

    private static boolean checkMissedKeys(Collection<String> missedKeys, JsonArray arrayIterating, JsonArray arrayComparing) {
        boolean allEntriesFound = true;
        for (int arrayComparingIndex = 0; arrayComparingIndex < arrayComparing.length(); ++arrayComparingIndex) {
            JsonValue arrayComparingEntry = arrayComparing.get(arrayComparingIndex);
            boolean entryFound = false;
            for (int arrayIteratingIndex = 0; arrayIteratingIndex < arrayIterating.length(); ++arrayIteratingIndex) {
                JsonValue arrayIteratingEntry = arrayIterating.get(arrayIteratingIndex);
                if (arrayIteratingEntry.getType() != arrayComparingEntry.getType() || !ThemeValidationUtil.objectIncludesEntry(arrayIteratingEntry, arrayComparingEntry, missedKeys)) continue;
                entryFound = true;
                break;
            }
            if (!entryFound) {
                missedKeys.add(arrayComparingEntry.toJson());
            }
            allEntriesFound = allEntriesFound && entryFound;
        }
        return allEntriesFound;
    }

    private static boolean isFrontendResourceChangedOrMissingInBundle(Map<String, String> bundledHashes, File frontendFolder, File frontendResource) {
        String relativePath = frontendFolder.toPath().relativize(frontendResource.toPath()).toString().replaceAll("\\\\", "/");
        boolean presentInBundle = bundledHashes.containsKey(relativePath);
        if (presentInBundle) {
            String contentHash;
            try {
                contentHash = BundleValidationUtil.calculateHash(FileUtils.readFileToString((File)frontendResource, (Charset)StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return !bundledHashes.remove(relativePath).equals(contentHash);
        }
        return true;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(ThemeValidationUtil.class);
    }
}

