/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.frontend.AbstractFileGeneratorFallibleCommand;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTaskClientGenerator
extends AbstractFileGeneratorFallibleCommand {
    protected abstract String getFileContent() throws IOException;

    protected abstract File getGeneratedFile();

    protected abstract boolean shouldGenerate();

    @Override
    public void execute() throws ExecutionFailedException {
        if (!this.shouldGenerate()) {
            return;
        }
        File generatedFile = this.getGeneratedFile();
        try {
            this.writeIfChanged(generatedFile, this.getFileContent());
        }
        catch (IOException exception) {
            String errorMessage = String.format("Error writing '%s'", generatedFile);
            throw new ExecutionFailedException(errorMessage, exception);
        }
    }

    static Logger log() {
        return LoggerFactory.getLogger(AbstractTaskClientGenerator.class);
    }
}

