/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VersionsJsonConverter {
    static final String VAADIN_CORE_NPM_PACKAGE = "@vaadin/vaadin-core";
    static final String VAADIN_BUNDLES = "@vaadin/bundles";
    private static final String JS_VERSION = "jsVersion";
    private static final String NPM_NAME = "npmName";
    private static final String NPM_VERSION = "npmVersion";
    public static final String EXCLUSIONS = "exclusions";
    public static final String MODE = "mode";
    public static final String MODE_LIT = "lit";
    public static final String MODE_REACT = "react";
    public static final String MODE_ALL = "all";
    private static final Object VAADIN_ROUTER = "@vaadin/router";
    private final JsonObject convertedObject;
    private boolean reactEnabled;
    private boolean excludeWebComponents;
    private Set<String> exclusions;

    private static Logger getLogger() {
        return LoggerFactory.getLogger(VersionsJsonConverter.class);
    }

    VersionsJsonConverter(JsonObject platformVersions, boolean reactEnabled, boolean excludeWebComponents) {
        this.reactEnabled = reactEnabled;
        this.excludeWebComponents = excludeWebComponents;
        this.exclusions = new HashSet<String>();
        this.convertedObject = Json.createObject();
        this.collectDependencies(platformVersions);
        this.excludeDependencies();
    }

    JsonObject getConvertedJson() {
        return this.convertedObject;
    }

    Set<String> getExclusions() {
        return this.exclusions;
    }

    private void collectDependencies(JsonObject obj) {
        for (String key : obj.keys()) {
            JsonValue value = obj.get(key);
            if (!(value instanceof JsonObject)) continue;
            JsonObject json = (JsonObject)value;
            if (json.hasKey(NPM_NAME)) {
                this.addDependency(json);
                continue;
            }
            this.collectDependencies(json);
        }
    }

    private void excludeDependencies() {
        for (String key : this.convertedObject.keys()) {
            if (!this.exclusions.contains(key)) continue;
            this.convertedObject.remove(key);
        }
    }

    private boolean isIncludedByMode(String mode) {
        if (mode == null || mode.isBlank() || MODE_ALL.equalsIgnoreCase(mode)) {
            return true;
        }
        if (this.excludeWebComponents) {
            return false;
        }
        if (this.reactEnabled) {
            return MODE_REACT.equalsIgnoreCase(mode);
        }
        return MODE_LIT.equalsIgnoreCase(mode);
    }

    private void addDependency(JsonObject obj) {
        String version;
        String mode;
        assert (obj.hasKey(NPM_NAME));
        String npmName = obj.getString(NPM_NAME);
        String string = mode = obj.hasKey(MODE) ? obj.getString(MODE) : null;
        if (Objects.equals(npmName, VAADIN_CORE_NPM_PACKAGE)) {
            return;
        }
        if (this.excludeWebComponents && Objects.equals(npmName, VAADIN_BUNDLES)) {
            this.exclusions.add(npmName);
            return;
        }
        if (this.reactEnabled && Objects.equals(npmName, VAADIN_ROUTER)) {
            this.exclusions.add(npmName);
            return;
        }
        if (!this.isIncludedByMode(mode)) {
            if (this.excludeWebComponents) {
                if (MODE_REACT.equalsIgnoreCase(mode)) {
                    this.exclusions.add(npmName);
                }
                this.collectExclusions(obj);
            }
            return;
        }
        if (obj.hasKey(NPM_VERSION)) {
            version = obj.getString(NPM_VERSION);
        } else if (obj.hasKey(JS_VERSION)) {
            version = obj.getString(JS_VERSION);
        } else {
            throw new IllegalStateException("Vaadin code versions file contains unexpected data: dependency '" + npmName + "' has no 'npmVersion'/'jsVersion' . Please report a bug in https://github.com/vaadin/platform/issues/new");
        }
        this.convertedObject.put(npmName, version);
        this.collectExclusions(obj);
        VersionsJsonConverter.getLogger().debug("versions.json adds dependency {} with version {}{}", new Object[]{npmName, version, mode != null ? " for mode " + mode : ""});
    }

    private void collectExclusions(JsonObject obj) {
        JsonArray array;
        if (obj.hasKey(EXCLUSIONS) && (array = obj.getArray(EXCLUSIONS)) != null) {
            IntStream.range(0, array.length()).forEach(i -> this.exclusions.add(array.getString(i)));
        }
    }
}

