/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.core.util.Separators;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.vaadin.flow.internal.JsonDecodingException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.Stream;

public final class JacksonUtils {
    private static final String CANNOT_CONVERT_NULL_TO_A_JSON_OBJECT = "Cannot convert null to JSON";
    private static final String CANNOT_CONVERT_NULL_TO_OBJECT = "Cannot convert null to Java object";
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final Set<Collector.Characteristics> arrayCollectorCharacteristics;

    public static ObjectMapper getMapper() {
        return objectMapper;
    }

    public static ObjectNode createObjectNode() {
        return objectMapper.createObjectNode();
    }

    public static ArrayNode createArrayNode() {
        return objectMapper.createArrayNode();
    }

    public static ObjectNode readTree(String json) {
        try {
            return (ObjectNode)objectMapper.readTree(json);
        }
        catch (JsonProcessingException e) {
            throw new JsonDecodingException("Could not parse json content", e);
        }
    }

    public static JsonNode createNode(Object value) {
        return objectMapper.valueToTree(value);
    }

    private JacksonUtils() {
    }

    public static boolean jsonEquals(JsonNode a, JsonNode b) {
        assert (a != null);
        assert (b != null);
        if (a == b) {
            return true;
        }
        JsonNodeType type = a.getNodeType();
        if (type != b.getNodeType()) {
            return false;
        }
        return switch (type) {
            case JsonNodeType.NULL -> true;
            case JsonNodeType.BOOLEAN -> JacksonUtils.booleanEqual(a, b);
            case JsonNodeType.NUMBER -> JacksonUtils.numbersEqual(a, b);
            case JsonNodeType.STRING -> JacksonUtils.stringEqual(a, b);
            case JsonNodeType.OBJECT -> JacksonUtils.jsonObjectEquals(a, b);
            case JsonNodeType.ARRAY -> JacksonUtils.jsonArrayEquals((ArrayNode)a, (ArrayNode)b);
            default -> throw new IllegalArgumentException("Unsupported JsonType: " + type);
        };
    }

    public static boolean stringEqual(JsonNode a, JsonNode b) {
        assert (a.getNodeType() == JsonNodeType.STRING);
        assert (b.getNodeType() == JsonNodeType.STRING);
        return a.asText().equals(b.asText());
    }

    public static boolean booleanEqual(JsonNode a, JsonNode b) {
        assert (a.getNodeType() == JsonNodeType.BOOLEAN);
        assert (b.getNodeType() == JsonNodeType.BOOLEAN);
        return a.asBoolean() == b.asBoolean();
    }

    public static boolean numbersEqual(JsonNode a, JsonNode b) {
        assert (a.getNodeType() == JsonNodeType.NUMBER);
        assert (b.getNodeType() == JsonNodeType.NUMBER);
        return Double.doubleToRawLongBits(a.doubleValue()) == Double.doubleToRawLongBits(b.doubleValue());
    }

    private static boolean jsonObjectEquals(JsonNode a, JsonNode b) {
        assert (a != null);
        assert (b != null);
        if (a == b) {
            return true;
        }
        List<String> keys = JacksonUtils.getKeys(a);
        List<String> bkeys = JacksonUtils.getKeys(b);
        if (keys.size() != bkeys.size()) {
            return false;
        }
        for (String key : keys) {
            JsonNode value = b.get(key);
            if (value != null && JacksonUtils.jsonEquals(a.get(key), value)) continue;
            return false;
        }
        return true;
    }

    public static List<String> getKeys(JsonNode node) {
        ArrayList<String> keys = new ArrayList<String>();
        node.fieldNames().forEachRemaining(keys::add);
        return keys;
    }

    private static boolean jsonArrayEquals(ArrayNode a, ArrayNode b) {
        assert (a != null);
        assert (b != null);
        if (a == b) {
            return true;
        }
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            if (JacksonUtils.jsonEquals(a.get(i), b.get(i))) continue;
            return false;
        }
        return true;
    }

    public static <T extends JsonNode> Stream<T> stream(final ArrayNode array) {
        if (array == null) {
            return Stream.empty();
        }
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                return array.get(index);
            }

            @Override
            public int size() {
                return array.size();
            }
        }.stream();
    }

    public static Stream<JsonNode> objectStream(ArrayNode array) {
        return JacksonUtils.stream(array);
    }

    public static DoubleStream numberStream(ArrayNode array) {
        return JacksonUtils.stream(array).mapToDouble(DoubleNode::doubleValue);
    }

    public static Collector<JsonNode, ArrayNode, ArrayNode> asArray() {
        return new ArrayNodeCollector();
    }

    public static ArrayNode createArray(JsonNode ... values) {
        return Stream.of(values).collect(JacksonUtils.asArray());
    }

    public static <T> ObjectNode createObject(Map<String, T> map, Function<T, JsonNode> itemToJson) {
        ObjectNode object = objectMapper.createObjectNode();
        map.forEach((key, value) -> object.put(key, (JsonNode)itemToJson.apply(value)));
        return object;
    }

    public static ObjectNode beanToJson(Object bean) {
        Objects.requireNonNull(bean, CANNOT_CONVERT_NULL_TO_A_JSON_OBJECT);
        return (ObjectNode)objectMapper.valueToTree(bean);
    }

    public static ArrayNode listToJson(List<?> list) {
        Objects.requireNonNull(list, CANNOT_CONVERT_NULL_TO_A_JSON_OBJECT);
        return (ArrayNode)objectMapper.valueToTree(list);
    }

    public static ObjectNode mapToJson(Map<String, ?> map) {
        Objects.requireNonNull(map, CANNOT_CONVERT_NULL_TO_A_JSON_OBJECT);
        return (ObjectNode)objectMapper.valueToTree(map);
    }

    public static <T> T readToObject(ObjectNode jsonObject, Class<T> tClass) {
        Objects.requireNonNull(jsonObject, CANNOT_CONVERT_NULL_TO_OBJECT);
        try {
            return (T)objectMapper.treeToValue((TreeNode)jsonObject, tClass);
        }
        catch (JsonProcessingException e) {
            throw new JsonDecodingException("Error converting JsonObject to " + tClass.getName(), e);
        }
    }

    public static <T> T readValue(ObjectNode jsonValue, Class<T> tClass) {
        return JacksonUtils.readToObject(jsonValue, tClass);
    }

    public static <T> T readValue(ObjectNode jsonValue, TypeReference<T> typeReference) {
        Objects.requireNonNull(jsonValue, CANNOT_CONVERT_NULL_TO_OBJECT);
        try {
            return (T)objectMapper.treeToValue((TreeNode)jsonValue, typeReference);
        }
        catch (JsonProcessingException e) {
            throw new JsonDecodingException("Error converting ObjectNode to " + typeReference.getType().getTypeName(), e);
        }
    }

    public static ObjectNode writeValue(Object object) {
        return (ObjectNode)objectMapper.valueToTree(object);
    }

    public static String toFileJson(JsonNode node) throws JsonProcessingException {
        DefaultPrettyPrinter filePrinter = new DefaultPrettyPrinter(Separators.createDefaultInstance().withObjectFieldValueSpacing(Separators.Spacing.AFTER));
        return objectMapper.writer().with((PrettyPrinter)filePrinter).writeValueAsString((Object)node);
    }

    static {
        objectMapper.registerModule((Module)new JavaTimeModule());
        arrayCollectorCharacteristics = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.IDENTITY_FINISH));
    }

    private static final class ArrayNodeCollector
    implements Collector<JsonNode, ArrayNode, ArrayNode> {
        private ArrayNodeCollector() {
        }

        @Override
        public Supplier<ArrayNode> supplier() {
            return () -> ((ObjectMapper)objectMapper).createArrayNode();
        }

        @Override
        public BiConsumer<ArrayNode, JsonNode> accumulator() {
            return ArrayNode::add;
        }

        @Override
        public BinaryOperator<ArrayNode> combiner() {
            return (left, right) -> {
                for (int i = 0; i < right.size(); ++i) {
                    left.set(left.size(), right.get(i));
                }
                return left;
            };
        }

        @Override
        public Function<ArrayNode, ArrayNode> finisher() {
            return Function.identity();
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return arrayCollectorCharacteristics;
        }
    }
}

