/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.NavigationTrigger;
import com.vaadin.flow.router.Router;
import elemental.json.JsonValue;
import java.util.EventObject;
import java.util.Optional;

public class NavigationEvent
extends EventObject {
    private final Location location;
    private final UI ui;
    private final NavigationTrigger trigger;
    private boolean forwardTo = false;
    private JsonValue state = null;
    private boolean forceInstantiation = false;
    private boolean recreateLayoutChain = false;

    public NavigationEvent(Router router, Location location, UI ui, NavigationTrigger trigger) {
        super(router);
        assert (location != null);
        assert (ui != null);
        assert (trigger != null);
        this.location = location;
        this.ui = ui;
        this.trigger = trigger;
    }

    public NavigationEvent(Router router, Location location, UI ui, NavigationTrigger trigger, JsonValue state, boolean forwardTo) {
        this(router, location, ui, trigger);
        this.state = state;
        this.forwardTo = forwardTo;
    }

    public NavigationEvent(Router router, Location location, UI ui, NavigationTrigger trigger, JsonValue state, boolean forwardTo, boolean forceInstantiation, boolean recreateLayoutChain) {
        this(router, location, ui, trigger);
        this.state = state;
        this.forwardTo = forwardTo;
        this.forceInstantiation = forceInstantiation;
        this.recreateLayoutChain = recreateLayoutChain;
    }

    @Override
    public Router getSource() {
        return (Router)super.getSource();
    }

    public Location getLocation() {
        return this.location;
    }

    public UI getUI() {
        return this.ui;
    }

    public NavigationTrigger getTrigger() {
        return this.trigger;
    }

    public Optional<JsonValue> getState() {
        return this.state == null ? Optional.empty() : Optional.of(this.state);
    }

    public boolean isForwardTo() {
        return this.forwardTo;
    }

    public boolean isForceInstantiation() {
        return this.forceInstantiation;
    }

    public boolean isRecreateLayoutChain() {
        return this.recreateLayoutChain;
    }
}

