/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.auth;

import com.vaadin.flow.router.Layout;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.internal.RouteUtil;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.auth.AccessAnnotationChecker;
import com.vaadin.flow.server.auth.AccessCheckResult;
import com.vaadin.flow.server.auth.NavigationAccessChecker;
import com.vaadin.flow.server.auth.NavigationContext;
import jakarta.annotation.security.DenyAll;
import jakarta.annotation.security.PermitAll;
import jakarta.annotation.security.RolesAllowed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotatedViewAccessChecker
implements NavigationAccessChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotatedViewAccessChecker.class);
    private final AccessAnnotationChecker accessAnnotationChecker;

    public AnnotatedViewAccessChecker() {
        this(new AccessAnnotationChecker());
    }

    public AnnotatedViewAccessChecker(AccessAnnotationChecker accessAnnotationChecker) {
        this.accessAnnotationChecker = accessAnnotationChecker;
    }

    @Override
    public AccessCheckResult check(NavigationContext context) {
        String denyReason;
        RouteRegistry registry;
        boolean noParents;
        Class<?> targetView = context.getNavigationTarget();
        if (RouteUtil.isAutolayoutEnabled(targetView, context.getLocation().getPath()) && (noParents = (registry = context.getRouter().getRegistry()).getRegisteredRoutes().stream().filter(routeData -> routeData.getNavigationTarget().equals(targetView)).map(data -> data.getParentLayouts().isEmpty()).findFirst().orElse(true).booleanValue()) && registry.hasLayout(context.getLocation().getPath())) {
            Class<? extends RouterLayout> layout = registry.getLayout(context.getLocation().getPath());
            boolean hasAccess = this.accessAnnotationChecker.hasAccess(layout, context.getPrincipal(), context::hasRole);
            if (!hasAccess) {
                LOGGER.debug("Denied access to view due to layout '{}' access rules", (Object)layout.getSimpleName());
                return context.deny("Consider adding one of the following annotations to make the layout accessible: @AnonymousAllowed, @PermitAll, @RolesAllowed.");
            }
        }
        boolean hasAccess = this.accessAnnotationChecker.hasAccess(targetView, context.getPrincipal(), context::hasRole);
        LOGGER.debug("Access to view '{}' with path '{}' is {}", new Object[]{context.getNavigationTarget().getName(), context.getLocation().getPath(), hasAccess ? "allowed" : "denied"});
        if (hasAccess) {
            return context.allow();
        }
        if (this.isImplicitlyDenyAllAnnotated(targetView)) {
            denyReason = "Consider adding one of the following annotations to make the view accessible: @AnonymousAllowed, @PermitAll, @RolesAllowed.";
            if (targetView.isAnnotationPresent(Layout.class) && context.getRouter().getRegistry().getTargetUrl(targetView).isEmpty()) {
                LOGGER.debug("Denied access to view due to layout '{}' access rules", (Object)targetView.getSimpleName());
                denyReason = "Consider adding one of the following annotations to make the layout accessible: @AnonymousAllowed, @PermitAll, @RolesAllowed.";
            }
        } else {
            denyReason = "Access is denied by annotations on the view.";
        }
        return context.deny(denyReason);
    }

    private boolean isImplicitlyDenyAllAnnotated(Class<?> targetView) {
        return !targetView.isAnnotationPresent(DenyAll.class) && !targetView.isAnnotationPresent(PermitAll.class) && !targetView.isAnnotationPresent(RolesAllowed.class);
    }
}

