/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.streams;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableRunnable;
import com.vaadin.flow.function.SerializableTriConsumer;
import com.vaadin.flow.server.streams.TransferContext;
import com.vaadin.flow.server.streams.TransferProgressListener;
import com.vaadin.flow.shared.Registration;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public abstract class TransferProgressAwareHandler<T, R extends TransferProgressAwareHandler>
implements Serializable {
    private List<TransferProgressListener> listeners;
    private UI ui;

    protected abstract TransferContext getTransferContext(T var1);

    protected Registration addTransferProgressListener(TransferProgressListener listener) {
        Objects.requireNonNull(listener, "Listener cannot be null");
        TransferProgressListenerWrapper wrapper = new TransferProgressListenerWrapper(listener);
        wrapper.setTransferUI(this.ui);
        return this.addTransferProgressListenerInternal(wrapper);
    }

    public R whenStart(final SerializableRunnable startHandler) {
        Objects.requireNonNull(startHandler, "Start handler cannot be null");
        this.addTransferProgressListenerInternal(new TransferProgressListener(){

            @Override
            public void onStart(TransferContext context) {
                TransferProgressAwareHandler.this.ui.access(startHandler::run);
            }
        });
        return (R)this;
    }

    public R whenStart(final SerializableConsumer<TransferContext> startHandler) {
        Objects.requireNonNull(startHandler, "Start handler cannot be null");
        this.addTransferProgressListenerInternal(new TransferProgressListener(){

            @Override
            public void onStart(TransferContext context) {
                TransferProgressAwareHandler.this.ui.access(() -> startHandler.accept(context));
            }
        });
        return (R)this;
    }

    public R onProgress(final SerializableTriConsumer<TransferContext, Long, Long> progressHandler, final long progressIntervalInBytes) {
        Objects.requireNonNull(progressHandler, "Progress handler cannot be null");
        this.addTransferProgressListenerInternal(new TransferProgressListener(){

            @Override
            public void onProgress(TransferContext context, long transferredBytes, long totalBytes) {
                TransferProgressAwareHandler.this.ui.access(() -> progressHandler.accept(context, transferredBytes, totalBytes));
            }

            @Override
            public long progressReportInterval() {
                return progressIntervalInBytes;
            }
        });
        return (R)this;
    }

    public R onProgress(SerializableTriConsumer<TransferContext, Long, Long> progressHandler) {
        return this.onProgress(progressHandler, 65536L);
    }

    public R onProgress(final SerializableBiConsumer<Long, Long> progressHandler, final long progressIntervalInBytes) {
        Objects.requireNonNull(progressHandler, "Progress handler cannot be null");
        this.addTransferProgressListenerInternal(new TransferProgressListener(){

            @Override
            public void onProgress(TransferContext context, long transferredBytes, long totalBytes) {
                TransferProgressAwareHandler.this.ui.access(() -> progressHandler.accept(transferredBytes, totalBytes));
            }

            @Override
            public long progressReportInterval() {
                return progressIntervalInBytes;
            }
        });
        return (R)this;
    }

    public R onProgress(SerializableBiConsumer<Long, Long> progressHandler) {
        return this.onProgress(progressHandler, 65536L);
    }

    public R whenComplete(final SerializableConsumer<Boolean> completeOrTerminateHandler) {
        Objects.requireNonNull(completeOrTerminateHandler, "Complete or terminate handler cannot be null");
        this.addTransferProgressListenerInternal(new TransferProgressListener(){

            @Override
            public void onError(TransferContext context, IOException reason) {
                TransferProgressAwareHandler.this.ui.access(() -> completeOrTerminateHandler.accept(false));
            }

            @Override
            public void onComplete(TransferContext context, long transferredBytes) {
                TransferProgressAwareHandler.this.ui.access(() -> completeOrTerminateHandler.accept(true));
            }
        });
        return (R)this;
    }

    public R whenComplete(final SerializableBiConsumer<TransferContext, Boolean> completeOrTerminateHandler) {
        Objects.requireNonNull(completeOrTerminateHandler, "Complete or terminate handler cannot be null");
        this.addTransferProgressListenerInternal(new TransferProgressListener(){

            @Override
            public void onError(TransferContext context, IOException reason) {
                TransferProgressAwareHandler.this.ui.access(() -> completeOrTerminateHandler.accept(context, false));
            }

            @Override
            public void onComplete(TransferContext context, long transferredBytes) {
                TransferProgressAwareHandler.this.ui.access(() -> completeOrTerminateHandler.accept(context, true));
            }
        });
        return (R)this;
    }

    protected List<TransferProgressListener> getListeners() {
        return this.listeners == null ? Collections.emptyList() : Collections.unmodifiableList(this.listeners);
    }

    protected void notifyError(T transferEvent, IOException ioe) {
        TransferContext transferContext = this.getTransferContext(transferEvent);
        this.getListeners().forEach(listener -> listener.onError(transferContext, ioe));
    }

    private Registration addTransferProgressListenerInternal(TransferProgressListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<TransferProgressListener>(4);
        }
        return Registration.addAndRemove(this.listeners, listener);
    }

    protected void setTransferUI(UI ui) {
        this.ui = ui;
        if (this.listeners != null) {
            this.listeners.stream().filter(l -> l instanceof TransferProgressListenerWrapper).map(TransferProgressListenerWrapper.class::cast).forEach(listener -> listener.setTransferUI(ui));
        }
    }

    private static final class TransferProgressListenerWrapper
    implements TransferProgressListener {
        private final TransferProgressListener delegate;
        private UI ui;

        public TransferProgressListenerWrapper(TransferProgressListener delegate) {
            this.delegate = delegate;
        }

        @Override
        public void onStart(TransferContext context) {
            this.ui.access(() -> this.delegate.onStart(context));
        }

        @Override
        public void onProgress(TransferContext context, long transferredBytes, long totalBytes) {
            this.ui.access(() -> this.delegate.onProgress(context, transferredBytes, totalBytes));
        }

        @Override
        public void onError(TransferContext context, IOException reason) {
            this.ui.access(() -> this.delegate.onError(context, reason));
        }

        @Override
        public void onComplete(TransferContext context, long transferredBytes) {
            this.ui.access(() -> this.delegate.onComplete(context, transferredBytes));
        }

        @Override
        public long progressReportInterval() {
            return this.delegate.progressReportInterval();
        }

        protected void setTransferUI(UI ui) {
            this.ui = ui;
        }
    }
}

