/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.auth.AccessAnnotationChecker;
import com.vaadin.hilla.EndpointCodeGenerator;
import com.vaadin.hilla.EndpointController;
import com.vaadin.hilla.EndpointInvoker;
import com.vaadin.hilla.EndpointNameChecker;
import com.vaadin.hilla.EndpointProperties;
import com.vaadin.hilla.EndpointRegistry;
import com.vaadin.hilla.EndpointUtil;
import com.vaadin.hilla.ExplicitNullableTypeChecker;
import com.vaadin.hilla.auth.CsrfChecker;
import com.vaadin.hilla.auth.EndpointAccessChecker;
import com.vaadin.hilla.endpointransfermapper.EndpointTransferMapper;
import com.vaadin.hilla.parser.jackson.JacksonObjectMapperFactory;
import jakarta.servlet.ServletContext;
import java.lang.reflect.Method;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcRegistrations;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.util.pattern.PathPatternParser;

@Configuration
public class EndpointControllerConfiguration {
    private static final EndpointTransferMapper ENDPOINT_TRANSFER_MAPPER = new EndpointTransferMapper();
    private final EndpointProperties endpointProperties;
    private ObjectMapper endpointMapper;

    public EndpointControllerConfiguration(EndpointProperties endpointProperties) {
        this.endpointProperties = endpointProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    AccessAnnotationChecker accessAnnotationChecker() {
        return new AccessAnnotationChecker();
    }

    @Bean
    EndpointAccessChecker accessChecker(AccessAnnotationChecker accessAnnotationChecker) {
        return new EndpointAccessChecker(accessAnnotationChecker);
    }

    @Bean
    CsrfChecker csrfChecker(ServletContext servletContext) {
        return new CsrfChecker(servletContext);
    }

    @Bean
    ObjectMapper hillaEndpointObjectMapper(ApplicationContext applicationContext, @Autowired(required=false) @Qualifier(value="endpointMapperFactory") JacksonObjectMapperFactory endpointMapperFactory) {
        if (this.endpointMapper == null) {
            ObjectMapper objectMapper = this.endpointMapper = endpointMapperFactory != null ? endpointMapperFactory.build() : EndpointControllerConfiguration.createDefaultEndpointMapper(applicationContext);
            if (this.endpointMapper != null) {
                this.endpointMapper.registerModule(ENDPOINT_TRANSFER_MAPPER.getJacksonModule());
            }
        }
        return this.endpointMapper;
    }

    private static ObjectMapper createDefaultEndpointMapper(ApplicationContext applicationContext) {
        ObjectMapper endpointMapper = new JacksonObjectMapperFactory.Json().build();
        ((Jackson2ObjectMapperBuilder)applicationContext.getBean(Jackson2ObjectMapperBuilder.class)).configure(endpointMapper);
        return endpointMapper;
    }

    @Bean
    EndpointInvoker endpointInvoker(ApplicationContext applicationContext, @Qualifier(value="hillaEndpointObjectMapper") ObjectMapper hillaEndpointObjectMapper, ExplicitNullableTypeChecker explicitNullableTypeChecker, ServletContext servletContext, EndpointRegistry endpointRegistry) {
        return new EndpointInvoker(applicationContext, hillaEndpointObjectMapper, explicitNullableTypeChecker, servletContext, endpointRegistry);
    }

    @Bean
    EndpointNameChecker endpointNameChecker() {
        return new EndpointNameChecker();
    }

    @Bean
    EndpointRegistry endpointRegistry(EndpointNameChecker endpointNameChecker) {
        return new EndpointRegistry(endpointNameChecker);
    }

    @Bean
    EndpointUtil endpointUtil() {
        return new EndpointUtil();
    }

    @Bean
    ExplicitNullableTypeChecker typeChecker() {
        return new ExplicitNullableTypeChecker();
    }

    @Bean
    WebMvcRegistrations webMvcRegistrationsHandlerMapping() {
        return new WebMvcRegistrations(){

            public RequestMappingHandlerMapping getRequestMappingHandlerMapping() {
                return new RequestMappingHandlerMapping(){

                    protected void registerHandlerMethod(Object handler, Method method, RequestMappingInfo mapping) {
                        if (EndpointController.class.equals(method.getDeclaringClass())) {
                            mapping = EndpointControllerConfiguration.this.prependEndpointPrefixUrl(mapping);
                        }
                        super.registerHandlerMethod(handler, method, mapping);
                    }
                };
            }
        };
    }

    private RequestMappingInfo prependEndpointPrefixUrl(RequestMappingInfo mapping) {
        RequestMappingInfo.Builder prefixMappingBuilder = RequestMappingInfo.paths((String[])new String[]{this.endpointProperties.getEndpointPrefix()});
        if (mapping.getPatternsCondition() == null) {
            RequestMappingInfo.BuilderConfiguration options = new RequestMappingInfo.BuilderConfiguration();
            options.setPatternParser(PathPatternParser.defaultInstance);
            prefixMappingBuilder.options(options);
        }
        return prefixMappingBuilder.build().combine(mapping);
    }

    @Bean
    EndpointCodeGenerator endpointCodeGenerator(ServletContext servletContext, EndpointController endpointController) {
        return new EndpointCodeGenerator((VaadinContext)new VaadinServletContext(servletContext), endpointController);
    }
}

