/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.crud;

import com.vaadin.hilla.crud.PropertyStringFilterSpecification;
import com.vaadin.hilla.crud.filter.AndFilter;
import com.vaadin.hilla.crud.filter.Filter;
import com.vaadin.hilla.crud.filter.OrFilter;
import com.vaadin.hilla.crud.filter.PropertyStringFilter;
import org.springframework.data.jpa.domain.Specification;

public final class JpaFilterConverter {
    private JpaFilterConverter() {
    }

    public static <T> Specification<T> toSpec(Filter rawFilter, Class<T> entity) {
        if (rawFilter == null) {
            return Specification.anyOf((Specification[])new Specification[0]);
        }
        if (rawFilter instanceof AndFilter) {
            AndFilter filter = (AndFilter)rawFilter;
            return Specification.allOf(filter.getChildren().stream().map(f -> JpaFilterConverter.toSpec(f, entity)).toList());
        }
        if (rawFilter instanceof OrFilter) {
            OrFilter filter = (OrFilter)rawFilter;
            return Specification.anyOf(filter.getChildren().stream().map(f -> JpaFilterConverter.toSpec(f, entity)).toList());
        }
        if (rawFilter instanceof PropertyStringFilter) {
            PropertyStringFilter filter = (PropertyStringFilter)rawFilter;
            return new PropertyStringFilterSpecification(filter);
        }
        throw new IllegalArgumentException("Unknown filter type " + rawFilter.getClass().getName());
    }
}

