/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.signals.core.event;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.hilla.signals.ValueSignal;
import com.vaadin.hilla.signals.core.event.InvalidEventTypeException;
import com.vaadin.hilla.signals.core.event.MissingFieldException;
import com.vaadin.hilla.signals.core.event.StateEvent;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;

public class ListStateEvent<T> {
    private final String id;
    private final EventType eventType;
    private Boolean accepted;
    private final T value;
    private final Collection<ListEntry<T>> entries;
    private UUID entryId;
    private final InsertPosition insertPosition;
    private String validationError;

    public ListStateEvent(String id, EventType eventType, Collection<ListEntry<T>> entries) {
        this.id = id;
        this.eventType = eventType;
        this.insertPosition = null;
        this.value = null;
        this.entries = entries;
    }

    public ListStateEvent(String id, EventType eventType, T value, InsertPosition insertPosition) {
        this.id = id;
        this.eventType = eventType;
        this.value = value;
        this.insertPosition = insertPosition;
        this.entries = null;
    }

    public ListStateEvent(ObjectNode json, Class<T> valueType) {
        this.id = StateEvent.extractId((JsonNode)json);
        this.eventType = ListStateEvent.extractEventType((JsonNode)json);
        this.value = this.eventType == EventType.INSERT ? StateEvent.convertValue(StateEvent.extractValue((JsonNode)json, true), valueType) : null;
        this.insertPosition = this.eventType == EventType.INSERT ? ListStateEvent.extractPosition((JsonNode)json) : null;
        this.entryId = this.eventType == EventType.REMOVE ? UUID.fromString(ListStateEvent.extractEntryId((JsonNode)json)) : null;
        this.entries = null;
    }

    private static EventType extractEventType(JsonNode json) {
        String rawType = StateEvent.extractRawEventType(json);
        try {
            return EventType.of(rawType);
        }
        catch (IllegalArgumentException e) {
            String message = String.format("Invalid event type %s. Type should be one of: %s", rawType, Arrays.toString((Object[])EventType.values()));
            throw new InvalidEventTypeException(message, e);
        }
    }

    private static InsertPosition extractPosition(JsonNode json) {
        JsonNode rawPosition = json.get("position");
        if (rawPosition == null) {
            String message = String.format("Missing event position. Position is required, and should be one of: %s", Arrays.toString((Object[])InsertPosition.values()));
            throw new MissingFieldException(message);
        }
        try {
            return InsertPosition.of(rawPosition.asText());
        }
        catch (IllegalArgumentException e) {
            String message = String.format("Invalid event position: %s. Position should be one of: %s", rawPosition.asText(), Arrays.toString((Object[])InsertPosition.values()));
            throw new InvalidEventTypeException(message, e);
        }
    }

    public static String extractParentSignalId(JsonNode json) {
        JsonNode rawParentSignalId = json.get("parentSignalId");
        if (rawParentSignalId == null) {
            return null;
        }
        return rawParentSignalId.asText();
    }

    private static String extractEntryId(JsonNode json) {
        JsonNode entryId = json.get("entryId");
        if (entryId == null) {
            throw new MissingFieldException("entryId");
        }
        return entryId.asText();
    }

    public ObjectNode toJson() {
        ObjectNode snapshotData = StateEvent.MAPPER.createObjectNode();
        snapshotData.put("id", this.id);
        snapshotData.put("type", this.eventType.name().toLowerCase());
        if (this.value != null) {
            snapshotData.set("value", StateEvent.MAPPER.valueToTree(this.value));
        }
        if (this.entries != null) {
            ArrayNode snapshotEntries = StateEvent.MAPPER.createArrayNode();
            this.entries.forEach(entry -> {
                ObjectNode entryNode = snapshotEntries.addObject();
                entryNode.put("id", entry.id().toString());
                if (entry.next() != null) {
                    entryNode.put("next", entry.next().toString());
                }
                if (entry.previous() != null) {
                    entryNode.put("prev", entry.previous().toString());
                }
                if (entry.value() != null) {
                    entryNode.set("value", StateEvent.MAPPER.valueToTree(entry.value()));
                }
            });
            snapshotData.set("entries", (JsonNode)snapshotEntries);
        }
        if (this.insertPosition != null) {
            snapshotData.put("position", this.insertPosition.name().toLowerCase());
        }
        if (this.entryId != null) {
            snapshotData.put("entryId", this.entryId.toString());
        }
        if (this.accepted != null) {
            snapshotData.put("accepted", this.accepted);
        }
        if (this.validationError != null) {
            snapshotData.put("validationError", this.validationError);
        }
        return snapshotData;
    }

    public String getId() {
        return this.id;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public Collection<ListEntry<T>> getEntries() {
        return this.entries;
    }

    public T getValue() {
        return this.value;
    }

    public InsertPosition getPosition() {
        return this.insertPosition;
    }

    public UUID getEntryId() {
        return this.entryId;
    }

    public void setEntryId(UUID entryId) {
        this.entryId = entryId;
    }

    public Boolean getAccepted() {
        return this.accepted;
    }

    public void setAccepted(Boolean accepted) {
        this.accepted = accepted;
    }

    public String getValidationError() {
        return this.validationError;
    }

    public void setValidationError(String validationError) {
        this.validationError = validationError;
    }

    public static enum EventType {
        SNAPSHOT,
        INSERT,
        REMOVE;


        public static EventType of(String type) {
            return EventType.valueOf(type.toUpperCase());
        }
    }

    public static enum InsertPosition {
        FIRST,
        LAST,
        BEFORE,
        AFTER;


        public static InsertPosition of(String direction) {
            return InsertPosition.valueOf(direction.toUpperCase());
        }
    }

    public static final class Field {
        public static final String NEXT = "next";
        public static final String PREV = "prev";
        public static final String POSITION = "position";
        public static final String ENTRIES = "entries";
        public static final String ENTRY_ID = "entryId";
        public static final String PARENT_SIGNAL_ID = "parentSignalId";
    }

    public static interface ListEntry<T> {
        public UUID id();

        @Nullable
        public UUID previous();

        @Nullable
        public UUID next();

        public T value();

        public ValueSignal<T> getValueSignal();
    }

    @FunctionalInterface
    public static interface ListEntryFactory<T> {
        public ListEntry<T> create(UUID var1, UUID var2, UUID var3, T var4, Class<T> var5);
    }
}

