/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.parser.plugins.backbone;

import com.vaadin.hilla.parser.core.AbstractNode;
import com.vaadin.hilla.parser.core.AbstractPlugin;
import com.vaadin.hilla.parser.core.Node;
import com.vaadin.hilla.parser.core.NodeDependencies;
import com.vaadin.hilla.parser.core.NodePath;
import com.vaadin.hilla.parser.models.ClassInfoModel;
import com.vaadin.hilla.parser.models.ClassRefSignatureModel;
import com.vaadin.hilla.parser.models.MethodInfoModel;
import com.vaadin.hilla.parser.models.SignatureModel;
import com.vaadin.hilla.parser.models.TypeArgumentModel;
import com.vaadin.hilla.parser.models.TypeParameterModel;
import com.vaadin.hilla.parser.models.TypeVariableModel;
import com.vaadin.hilla.parser.plugins.backbone.BackbonePluginConfiguration;
import com.vaadin.hilla.parser.plugins.backbone.nodes.EndpointExposedNode;
import com.vaadin.hilla.parser.plugins.backbone.nodes.EndpointNode;
import com.vaadin.hilla.parser.plugins.backbone.nodes.EndpointNonExposedNode;
import com.vaadin.hilla.parser.plugins.backbone.nodes.EndpointSignatureNode;
import com.vaadin.hilla.parser.plugins.backbone.nodes.MethodNode;
import com.vaadin.hilla.parser.plugins.backbone.nodes.TypeSignatureNode;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.jspecify.annotations.NonNull;

public final class EndpointExposedPlugin
extends AbstractPlugin<BackbonePluginConfiguration> {
    public void enter(NodePath<?> nodePath) {
    }

    public void exit(NodePath<?> nodePath) {
    }

    public @NonNull Node<?, ?> resolve(@NonNull Node<?, ?> node, @NonNull NodePath<?> parentPath) {
        if (node instanceof MethodNode && parentPath.getNode() instanceof EndpointExposedNode) {
            return MethodNode.of((MethodInfoModel)((MethodNode)node).getSource());
        }
        if (!(node instanceof TypeSignatureNode)) {
            return node;
        }
        SignatureModel signature = (SignatureModel)node.getSource();
        if (!(signature instanceof TypeParameterModel)) {
            return node;
        }
        return TypeSignatureNode.of(this.resolveTypeParameter((TypeParameterModel)signature, parentPath));
    }

    public @NonNull NodeDependencies scan(@NonNull NodeDependencies nodeDependencies) {
        Node node = nodeDependencies.getNode();
        if (node instanceof EndpointNode || node instanceof EndpointExposedNode || node instanceof EndpointNonExposedNode) {
            ClassInfoModel cls = (ClassInfoModel)node.getSource();
            return nodeDependencies.appendChildNodes(this.scanEndpointClassSignature(cls));
        }
        if (node instanceof EndpointSignatureNode) {
            ClassRefSignatureModel classRef = (ClassRefSignatureModel)node.getSource();
            ClassInfoModel classInfo = classRef.getClassInfo();
            return nodeDependencies.appendChildNodes(Stream.of(this.createEndpointHierarchyClassNode(classInfo)));
        }
        return nodeDependencies;
    }

    private Node<?, ?> createEndpointHierarchyClassNode(ClassInfoModel classInfo) {
        List<String> endpointExposedAnnotations = this.getStorage().getParserConfig().getEndpointExposedAnnotations().stream().map(Class::getName).toList();
        boolean exposed = classInfo.getAnnotations().stream().map(annInfo -> ((Annotation)annInfo.get()).annotationType()).map(Class::getName).anyMatch(endpointExposedAnnotations::contains);
        AbstractNode classInfoNode = exposed ? EndpointExposedNode.of(classInfo) : EndpointNonExposedNode.of(classInfo);
        return classInfoNode;
    }

    private SignatureModel resolveTypeParameter(TypeParameterModel typeParameter, NodePath<?> path) {
        Optional<NodePath> closestEndpointSignaturePath = path.stream().filter(p -> p.getNode() instanceof EndpointSignatureNode).findFirst();
        if (closestEndpointSignaturePath.isEmpty()) {
            return typeParameter;
        }
        NodePath endpointSignaturePath = closestEndpointSignaturePath.get();
        ClassRefSignatureModel classRef = (ClassRefSignatureModel)endpointSignaturePath.getNode().getSource();
        int paramIndex = classRef.getClassInfo().getTypeParameters().indexOf(typeParameter);
        TypeArgumentModel typeArg = (TypeArgumentModel)classRef.getTypeArguments().get(paramIndex);
        if (!typeArg.getWildcard().equals((Object)TypeArgumentModel.Wildcard.NONE)) {
            return typeParameter;
        }
        SignatureModel signature = (SignatureModel)typeArg.getAssociatedTypes().get(0);
        if (signature instanceof TypeVariableModel) {
            TypeParameterModel endpointTypeParameter = ((TypeVariableModel)signature).resolve();
            return this.resolveTypeParameter(endpointTypeParameter, endpointSignaturePath.getParentPath());
        }
        return signature;
    }

    private Stream<Node<?, ?>> scanEndpointClassSignature(ClassInfoModel endpointClass) {
        return Stream.concat(endpointClass.getSuperClass().stream(), endpointClass.getInterfaces().stream()).map(EndpointSignatureNode::of);
    }
}

