/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.parser.plugins.subtypes;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.vaadin.hilla.parser.core.AbstractNode;
import com.vaadin.hilla.parser.core.AbstractPlugin;
import com.vaadin.hilla.parser.core.Node;
import com.vaadin.hilla.parser.core.NodeDependencies;
import com.vaadin.hilla.parser.core.NodePath;
import com.vaadin.hilla.parser.core.Plugin;
import com.vaadin.hilla.parser.core.PluginConfiguration;
import com.vaadin.hilla.parser.models.ClassInfoModel;
import com.vaadin.hilla.parser.models.ClassRefSignatureModel;
import com.vaadin.hilla.parser.plugins.backbone.BackbonePlugin;
import com.vaadin.hilla.parser.plugins.backbone.EntityPlugin;
import com.vaadin.hilla.parser.plugins.backbone.nodes.EntityNode;
import com.vaadin.hilla.parser.plugins.backbone.nodes.TypedNode;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public final class SubTypesPlugin
extends AbstractPlugin<PluginConfiguration> {
    public void enter(NodePath<?> nodePath) {
    }

    public void exit(NodePath<?> nodePath) {
        Class cls;
        if (nodePath.getNode() instanceof UnionNode) {
            UnionNode unionNode = (UnionNode)nodePath.getNode();
            cls = (Class)((ClassInfoModel)unionNode.getSource()).get();
            if (((JsonTypeInfo[])cls.getAnnotationsByType(JsonTypeInfo.class)).length > 0) {
                Schema schema = (Schema)unionNode.getTarget();
                SubTypesPlugin.getJsonSubTypes(cls).map(JsonSubTypes.Type::value).forEach(c -> schema.addOneOfItem((Schema)new Schema<Object>(){
                    {
                        this.set$ref("#/components/schemas/" + c.getName());
                    }
                }));
            }
            EntityPlugin.attachSchemaWithNameToOpenApi((Schema)((Schema)unionNode.getTarget()), (String)(cls.getName() + "Union"), (OpenAPI)((OpenAPI)nodePath.getParentPath().getNode().getTarget()));
        }
        if (nodePath.getNode() instanceof EntityNode) {
            EntityNode entityNode = (EntityNode)nodePath.getNode();
            cls = (Class)((ClassInfoModel)entityNode.getSource()).get();
            Optional.ofNullable(cls.getSuperclass()).map(SubTypesPlugin::getJsonSubTypes).stream().flatMap(Function.identity()).filter(t -> cls.equals(t.value())).findAny().ifPresent(t -> {
                ComposedSchema schema = (ComposedSchema)entityNode.getTarget();
                schema.getAnyOf().stream().filter(s -> s instanceof ObjectSchema).map(ObjectSchema.class::cast).forEach(s -> s.addProperty("@type", (Schema)new StringSchema((JsonSubTypes.Type)t){
                    final /* synthetic */ JsonSubTypes.Type val$t;
                    {
                        this.val$t = type;
                        this.setType("string");
                        this.setExample(this.val$t.name());
                    }
                }));
            });
        }
    }

    public Collection<Class<? extends Plugin>> getRequiredPlugins() {
        return List.of(BackbonePlugin.class);
    }

    @Nonnull
    public NodeDependencies scan(@Nonnull NodeDependencies nodeDependencies) {
        if (!(nodeDependencies.getNode() instanceof TypedNode)) {
            return nodeDependencies;
        }
        TypedNode typedNode = (TypedNode)nodeDependencies.getNode();
        if (!(typedNode.getType() instanceof ClassRefSignatureModel)) {
            return nodeDependencies;
        }
        ClassRefSignatureModel ref = (ClassRefSignatureModel)typedNode.getType();
        if (ref.isJDKClass() || ref.isDate() || ref.isIterable()) {
            return nodeDependencies;
        }
        Class refClass = (Class)ref.getClassInfo().get();
        Stream<Node> subTypes = SubTypesPlugin.getJsonSubTypes(refClass).map(JsonSubTypes.Type::value).map(ClassInfoModel::of).map(EntityNode::of);
        if (((JsonTypeInfo[])refClass.getAnnotationsByType(JsonTypeInfo.class)).length > 0) {
            UnionNode unionType = UnionNode.of(ref.getClassInfo());
            subTypes = Stream.concat(Stream.of(unionType), subTypes);
        }
        return nodeDependencies.appendRelatedNodes(subTypes);
    }

    private static Stream<JsonSubTypes.Type> getJsonSubTypes(Class<?> cls) {
        return Optional.of(cls).map(c -> (JsonSubTypes[])c.getAnnotationsByType(JsonSubTypes.class)).filter(a -> ((JsonSubTypes[])a).length > 0).map(a -> a[0]).map(JsonSubTypes::value).stream().flatMap(Arrays::stream);
    }

    public static class UnionNode
    extends AbstractNode<ClassInfoModel, Schema<?>> {
        private UnionNode(@Nonnull ClassInfoModel source, @Nonnull ObjectSchema target) {
            super((Object)source, (Object)target);
        }

        @Nonnull
        public static UnionNode of(@Nonnull ClassInfoModel model) {
            return new UnionNode(model, new ObjectSchema());
        }
    }
}

