/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.parser.plugins.transfertypes;

import com.vaadin.hilla.mappedtypes.Order;
import com.vaadin.hilla.mappedtypes.Pageable;
import com.vaadin.hilla.mappedtypes.Sort;
import com.vaadin.hilla.parser.core.AbstractPlugin;
import com.vaadin.hilla.parser.core.Node;
import com.vaadin.hilla.parser.core.NodeDependencies;
import com.vaadin.hilla.parser.core.NodePath;
import com.vaadin.hilla.parser.core.Plugin;
import com.vaadin.hilla.parser.core.PluginConfiguration;
import com.vaadin.hilla.parser.models.ClassInfoModel;
import com.vaadin.hilla.parser.models.ClassRefSignatureModel;
import com.vaadin.hilla.parser.models.SignatureModel;
import com.vaadin.hilla.parser.plugins.backbone.BackbonePlugin;
import com.vaadin.hilla.parser.plugins.backbone.nodes.TypedNode;
import com.vaadin.hilla.runtime.transfertypes.EndpointSubscription;
import com.vaadin.hilla.runtime.transfertypes.Flux;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public final class TransferTypesPlugin
extends AbstractPlugin<PluginConfiguration> {
    private static final Map<String, Class<?>> classMap = new HashMap();

    public TransferTypesPlugin() {
        classMap.put("org.springframework.data.domain.Page", List.class);
        classMap.put("org.springframework.data.domain.Pageable", Pageable.class);
        classMap.put("org.springframework.data.domain.Sort$Order", Order.class);
        classMap.put("org.springframework.data.domain.Sort", Sort.class);
        classMap.put(UUID.class.getName(), String.class);
        classMap.put("reactor.core.publisher.Flux", Flux.class);
        classMap.put("com.vaadin.hilla.EndpointSubscription", EndpointSubscription.class);
    }

    public void enter(NodePath<?> nodePath) {
    }

    public void exit(NodePath<?> nodePath) {
    }

    public Collection<Class<? extends Plugin>> getRequiredPlugins() {
        return List.of(BackbonePlugin.class);
    }

    @Nonnull
    public NodeDependencies scan(@Nonnull NodeDependencies nodeDependencies) {
        return nodeDependencies.processChildNodes(this::processNodes).processRelatedNodes(this::processNodes);
    }

    private Node<?, ?> mapClassRefNodes(Node<?, ?> node) {
        if (!(node instanceof TypedNode)) {
            return node;
        }
        return (Node)((TypedNode)node).processType(this::processType);
    }

    private Stream<Node<?, ?>> processNodes(Stream<Node<?, ?>> nodes) {
        return nodes.map(this::mapClassRefNodes);
    }

    private SignatureModel processType(SignatureModel signature) {
        if (!(signature instanceof ClassRefSignatureModel)) {
            return signature;
        }
        ClassRefSignatureModel classRef = (ClassRefSignatureModel)signature;
        String className = classRef.getClassInfo().getName();
        if (!classMap.containsKey(className)) {
            return signature;
        }
        ClassInfoModel mappedClassInfo = ClassInfoModel.of(classMap.get(className));
        return ClassRefSignatureModel.of((ClassInfoModel)mappedClassInfo, (List)classRef.getTypeArguments(), (List)classRef.getAnnotations());
    }
}

