/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.charts.model;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.vaadin.flow.component.charts.model.AbstractSeries;
import com.vaadin.flow.component.charts.model.Node;
import com.vaadin.flow.component.charts.model.NodeSeriesItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

@JsonPropertyOrder(value={"nodes", "values"})
public class NodeSeries
extends AbstractSeries {
    private Set<Node> nodes;
    private List<NodeSeriesItem> data;

    public void add(NodeSeriesItem nodeSeriesItem) {
        this.validateNodeSeriesItem(nodeSeriesItem);
        this.ensureData().add(nodeSeriesItem);
        this.addNode(nodeSeriesItem.getFrom());
        this.addNode(nodeSeriesItem.getTo());
    }

    public NodeSeriesItem add(Node from, Node to) {
        NodeSeriesItem item = new NodeSeriesItem(from, to);
        this.add(item);
        return item;
    }

    public void addNode(Node node) {
        this.validateNode(node, "Node");
        this.ensureNodes().add(node);
    }

    public void remove(NodeSeriesItem nodeSeriesItem) {
        if (this.data != null) {
            this.data.remove(nodeSeriesItem);
        }
    }

    public void remove(Node node) {
        if (this.nodes != null) {
            this.nodes.remove(node);
        }
    }

    public List<NodeSeriesItem> getData() {
        if (this.data == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.data);
    }

    public Set<Node> getNodes() {
        if (this.nodes == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.nodes);
    }

    private void validateNodeSeriesItem(NodeSeriesItem item) {
        String description = "NodeSeriesItem";
        this.validate(item, description);
        this.validateNode(item.getFrom(), "From node");
        this.validateNode(item.getTo(), "To node");
    }

    private List<NodeSeriesItem> ensureData() {
        this.data = this.data != null ? this.data : new ArrayList<NodeSeriesItem>();
        return this.data;
    }

    private Set<Node> ensureNodes() {
        this.nodes = this.nodes != null ? this.nodes : new LinkedHashSet<Node>();
        return this.nodes;
    }

    private void validateNode(Node node, String description) {
        this.validate(node, description);
        this.validate(node.getId(), description + " id");
    }

    private void validate(Object object, String description) {
        if (object == null) {
            String message = description + " may not be null";
            throw new IllegalArgumentException(message);
        }
    }
}

