/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.charts.model.serializers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.vaadin.flow.component.charts.model.DataSeriesItem;
import com.vaadin.flow.component.charts.model.OhlcItem;
import com.vaadin.flow.component.charts.model.serializers.BeanSerializationDelegate;
import com.vaadin.flow.component.charts.model.serializers.BeanSerializerDelegator;
import java.io.IOException;

public class DataSeriesItemBeanSerializer
extends BeanSerializationDelegate<DataSeriesItem> {
    @Override
    public Class<DataSeriesItem> getBeanClass() {
        return DataSeriesItem.class;
    }

    @Override
    public void serialize(DataSeriesItem bean, BeanSerializerDelegator<DataSeriesItem> serializer, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (bean.isCustomized()) {
            jgen.writeStartObject();
            serializer.serializeFields(bean, jgen, provider);
            jgen.writeEndObject();
        } else if (bean instanceof OhlcItem) {
            OhlcItem ohlcBean = (OhlcItem)bean;
            ArrayNode jsonArray = JsonNodeFactory.instance.arrayNode();
            jsonArray.addPOJO((Object)ohlcBean.getX());
            jsonArray.addPOJO((Object)ohlcBean.getOpen());
            jsonArray.addPOJO((Object)ohlcBean.getHigh());
            jsonArray.addPOJO((Object)ohlcBean.getLow());
            jsonArray.addPOJO((Object)ohlcBean.getClose());
            jgen.writeTree((TreeNode)jsonArray);
        } else {
            Number x = bean.getX();
            Number y = bean.getY();
            if (x != null) {
                ArrayNode jsonArray = JsonNodeFactory.instance.arrayNode();
                jsonArray.addPOJO((Object)x);
                if (y != null) {
                    jsonArray.addPOJO((Object)y);
                } else if (bean.getLow() != null) {
                    jsonArray.addPOJO((Object)bean.getLow());
                    jsonArray.addPOJO((Object)bean.getHigh());
                } else {
                    jsonArray.addNull();
                    jsonArray.addNull();
                }
                jgen.writeTree((TreeNode)jsonArray);
            } else if (y != null) {
                jgen.writeObject((Object)y);
            } else {
                ArrayNode jsonArray = JsonNodeFactory.instance.arrayNode();
                jsonArray.addPOJO((Object)bean.getLow());
                jsonArray.addPOJO((Object)bean.getHigh());
                jgen.writeTree((TreeNode)jsonArray);
            }
        }
    }
}

