/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver.viteproxy;

import com.vaadin.base.devserver.viteproxy.ViteWebsocketConnection;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.Session;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViteWebsocketProxy
implements MessageHandler.Whole<String> {
    private final ViteWebsocketConnection viteConnection;

    public ViteWebsocketProxy(Session browserSession, Integer vitePort, String vitePath) {
        this.viteConnection = new ViteWebsocketConnection(vitePort, vitePath, browserSession.getNegotiatedSubprotocol(), msg -> {
            try {
                browserSession.getBasicRemote().sendText(msg);
                ViteWebsocketProxy.getLogger().debug("Message sent to browser: {}", msg);
            }
            catch (IOException e) {
                ViteWebsocketProxy.getLogger().debug("Error sending message to browser", (Throwable)e);
            }
        }, () -> {
            try {
                browserSession.close();
            }
            catch (IOException e) {
                ViteWebsocketProxy.getLogger().debug("Error closing browser connection", (Throwable)e);
            }
        }, err -> {
            ViteWebsocketProxy.getLogger().error("Error creating Vite proxy connection", err);
            try {
                browserSession.close();
            }
            catch (IOException e1) {
                ViteWebsocketProxy.getLogger().debug("Error closing browser connection", (Throwable)e1);
            }
        });
    }

    protected static Logger getLogger() {
        return LoggerFactory.getLogger(ViteWebsocketProxy.class);
    }

    public void onMessage(String message) {
        ViteWebsocketProxy.getLogger().debug("Got message from browser: {}", (Object)message);
        try {
            this.viteConnection.send(message);
            ViteWebsocketProxy.getLogger().debug("Sent message to Vite: {}", (Object)message);
        }
        catch (InterruptedException | ExecutionException e) {
            ViteWebsocketProxy.getLogger().debug("Error sending message ({}) to Vite", (Object)message, (Object)e);
        }
    }

    public void close() {
        try {
            this.viteConnection.close();
        }
        catch (InterruptedException | ExecutionException e) {
            ViteWebsocketProxy.getLogger().debug("Error closing connection to Vite", (Throwable)e);
        }
    }
}

