/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring;

import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.server.ServiceException;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.spring.ForwardingRequestWrapper;
import com.vaadin.flow.spring.SpringVaadinServletService;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;

public class SpringServlet
extends VaadinServlet {
    private static final List<String> PROPERTY_NAMES = Arrays.asList("productionMode", "disable-xsrf-protection", "closeIdleSessions", "heartbeatInterval", "sendUrlsAsParameters", "pushMode", "pushURL", "syncIdCheck", "pushLongPollingSuspendTimeout", "requestTiming", "disable.webjars", "brotli", "load.es5.adapters", "original.frontend.resources", "frontend.url.es5", "frontend.url.es6", "i18n.provider", "disable.automatic.servlet.registration");
    private final ApplicationContext context;
    private final boolean forwardingEnforced;

    public SpringServlet(ApplicationContext context, boolean forwardingEnforced) {
        this.context = context;
        this.forwardingEnforced = forwardingEnforced;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        super.service(this.wrapRequest(request), response);
    }

    protected VaadinServletService createServletService(DeploymentConfiguration deploymentConfiguration) throws ServiceException {
        SpringVaadinServletService service = new SpringVaadinServletService(this, deploymentConfiguration, this.context);
        service.init();
        return service;
    }

    protected DeploymentConfiguration createDeploymentConfiguration(Properties initParameters) {
        Properties properties = new Properties(initParameters);
        this.config(properties);
        return super.createDeploymentConfiguration(properties);
    }

    private HttpServletRequest wrapRequest(HttpServletRequest request) {
        if (this.forwardingEnforced && request.getPathInfo() == null) {
            return new ForwardingRequestWrapper(request);
        }
        return request;
    }

    private void config(Properties properties) {
        this.setProperties(PROPERTY_NAMES, properties);
    }

    private void setProperties(List<String> propertyNames, Properties properties) {
        propertyNames.stream().forEach(property -> this.setProperty((String)property, properties));
    }

    private void setProperty(String property, Properties properties) {
        this.setProperty("vaadin." + property, property, properties);
    }

    private void setProperty(String envProperty, String initParam, Properties properties) {
        Environment env = (Environment)this.context.getBean(Environment.class);
        String productionMode = env.getProperty(envProperty);
        if (productionMode != null) {
            properties.put(initParam, productionMode);
        }
    }
}

